#!/usr/bin/env python

"""Setup script to test/demonstrate extensibility of the Distutils
   by extending an existing command class."""

from distutils.command import build
from distutils.core import setup, Command


class Build (build.Build):

    def run (self):
        self.run_peer ('greet')
        build.Build.run (self)

# class Build


class Greet (Command):

    options = [('name=', None,
                "your first name"),
               ('message=', 'm',
                "message to print")]

    def set_default_options (self):
        self.name = None
        self.message = None

    def set_final_options (self):
        if self.message is None:
            if self.name is not None:
                self.message = "Hello, %s!" % self.name
            else:
                self.message = "Howdy, stranger"

    def run (self):
        self.announce (self.message)

# class Greet


setup (# Distribution meta-data
       name = "sample",
       version = "1.0",
       description = "Distutils sample distribution #1 (alt. setup script)",

       # Description of the modules and packages in the distribution
       packages = [''],                 # empty string means root "package"

       # Overridden command classes
       cmdclass = {'build': Build,
                   'greet': Greet}
      )
