#!/usr/bin/env python

# Setup script for building the Numeric extension to Python.

# To use:
#   * run this to build Numerical Python:
#       python setup.py build
#     or this to build and install it
#       python setup.py install


# created 1999/08 Perry Stoll
# modified 2000/01 Paul Dubois 
import os
from glob import glob
from distutils.command.install import install
from distutils.core import setup
from distutils.sysconfig import get_python_inc

headers = glob (os.path.join ("Include","*.h"))

class my_install (install):

    user_options = install.user_options + \
              [('install-header=', None,
                "C header file installation directory")]

    def initialize_options (self):
        install.initialize_options (self)
        self.install_header = None

    def finalize_options (self):
        install.finalize_options (self)
        if self.install_header is None:
            inc_base = get_python_inc (prefix=self.install_base)
            self.install_header = os.path.join (inc_base, "Numeric")

    def run (self):
        global headers

        install.run (self)
        self.mkpath (self.install_header)
        for header in headers:
            self.copy_file (header, self.install_header)

setup (name = "Numerical",
       version = "15.2",
       maintainer = "Paul Dubois",
       maintainer_email = "dubois@users.sourceforge.net",
       description = "Numerical Extension to Python",
       url = "http://numpy.sourceforge.net",

       cmdclass = {'install': my_install},
       packages = [''],
       package_dir = {'': 'Lib'},
       extra_path = 'Numeric',
       include_dirs = ['Include'],
       ext_modules = [('_numpy',
                       { 'sources' : ['Src/_numpymodule.c',
                                      'Src/arrayobject.c',
                                      'Src/ufuncobject.c'],
                       }
                      ),

                      ('multiarray',
                       { 'sources' : ['Src/multiarraymodule.c'],
                       }
                      ),

                      ('umath',
                       { 'sources': ['Src/umathmodule.c'], }
                      ),

                      ('fftpack',
                       { 'sources': ['Src/fftpackmodule.c',
                                     'Src/fftpack.c'], }
                      ),

                      ('lapack_lite',
                       { 'sources' : ['Src/lapack_litemodule.c',
                                      'Src/dlapack_lite.c',
                                      'Src/zlapack_lite.c',
                                      'Src/blas_lite.c',
                                      'Src/f2c_lite.c'], }
                      ),

                      ('ranlib',
                       { 'sources': ['Src/ranlibmodule.c',
                                     'Src/ranlib.c',
                                     'Src/com.c',
                                     'Src/linpack.c'], }
                      ),

                      ('arrayfns',
                        { 'sources': ['Src/arrayfnsmodule.c'],}
                      )
                     ]
       )
