#!/usr/bin/env python

"""Example setup.py for Marc-Andr Lemburg's mxDateTime module
   distribution."""

# created 1999/09/19, Greg Ward

__revision__ = "$Id: mxdatetime_setup.py,v 1.4 2000/03/02 01:49:46 gward Exp $"

from distutils.core import setup

setup (name = "mxDateTime",
       version = "1.3.0",
       description = "",
       author = "Marc-Andr Lemburg",
       author_email = "mal@lemburg.com",
       url = "http://starship.python.net/~lemburg/mxDateTime.html",

       packages = ['DateTime', 'DateTime.Examples', 'DateTime.mxDateTime'],
       package_dir = {'DateTime': ''},

       # XXX user might have to edit the macro definitions here: yuck!
       # Probably do need to support 'Setup' file or something similar.
       ext_modules = [('DateTime.mxDateTime.mxDateTime',
                       { 'sources': ['mxDateTime/mxDateTime.c'],
                         'include_dirs': ['mxDateTime'],
                         'macros': [('HAVE_STRFTIME', None),
                                    ('HAVE_STRPTIME', None),
                                    ('HAVE_TIMEGM', None)], }
                     )]
      )
