#!/usr/bin/env python

# 
# test script to try out CCompiler classes without the need for a build_ext
# command (or all that other Distutils machinery) in the way.
#
# GPW 1999/07/09
#
# $Id: test_cc.py,v 1.5 2000/03/09 03:19:08 gward Exp $
#

import sys
from distutils.ccompiler import new_compiler

prog = sys.argv[0]
args = sys.argv[1:]
if len (args) == 0:
    plat = None
elif len (args) == 1:
    plat = args[0]
else:
    raise SystemExit, "usage: %s [platform]" % prog

cc = new_compiler (dry_run=1, verbose=1, plat=plat)

sep = '\n' + ('=' * 50) + '\n'
print sep,"barebones test: one .c -> .o -> shared obj"
cc.compile (['mymod.c'])
cc.link_shared_object (['mymod.o'], cc.shared_object_filename ('mymod'))

print sep , "add a macro definition"
cc.define_macro ('DEBUG', "1")
cc.compile (['mymod.c'])
cc.compile (['aux.c'])

print sep, "compile two at a time"
cc.compile (['mymod.c', 'aux.c'])

print sep, "undefine the macro at compile time"
cc.compile (['mymod.c', 'aux.c'], macros=[('DEBUG',)])

print sep, "redefine it"
cc.compile (['mymod.c', 'aux.c'], macros=[('DEBUG', "0")])

objects = cc.object_filenames (['mymod.c', 'aux.c'])
shared_obj = cc.shared_object_filename ('mymod')

print sep,"link with auxiliary object file"
cc.link_shared_object (objects, shared_obj)

print sep, "and with a library"
cc.link_shared_object (objects, shared_obj,
                       libraries=['stuff'])

print sep, "two libraries and a lib dir"
cc.link_shared_object (objects, shared_obj,
                       libraries=['stuff', 'junk'],
                       library_dirs=['/usr/local/lib'])

print sep, "add a 'built-in' lib dir and use it instead"
cc.add_library_dir ('/usr/local/lib')
cc.link_shared_object (objects, shared_obj,
                       libraries=['stuff'])

print sep, "add some built-in auxiliary object files and a library"
cc.set_link_objects (cc.object_filenames(['aux1.c','aux2.c']) + ['resources.bin'])
cc.add_library ('stuff')
cc.link_shared_object (cc.object_filenames (['mymod']), shared_obj)
