#!/usr/bin/env python

# 
# test script to try out CCompiler classes without the need for a build_ext
# command (or all that other Distutils machinery) in the way.
#
# GPW 1999/07/09
#
# $Id: test_cc.py,v 1.3 1999/08/29 18:24:34 gward Exp $
#

from distutils.ccompiler import new_compiler

cc = new_compiler (dry_run=1, verbose=1)

sep = '\n' + ('=' * 50) + '\n'
print sep,"barebones test: one .c -> .o -> .so"
cc.compile (['mymod.c'])
cc.link_shared_object (['mymod.o'], 'mymod.so')

print sep , "add a macro definition"
cc.define_macro ('DEBUG', "1")
cc.compile (['mymod.c'])
cc.compile (['aux.c'])

print sep, "compile two at a time"
cc.compile (['mymod.c', 'aux.c'])

print sep, "undefine the macro at compile time"
cc.compile (['mymod.c', 'aux.c'], [('DEBUG',)])

print sep, "redefine it"
cc.compile (['mymod.c', 'aux.c'], [('DEBUG', "0")])

print sep,"link with auxiliary object file"
cc.link_shared_object ([cc.object_name('mymod'), cc.object_name('aux')],
                       cc.shared_library_name('mymod'))

print sep, "and with a library"
cc.link_shared_object ([cc.object_name('mymod'), cc.object_name('aux')],
                       cc.shared_library_name('mymod'), ['stuff'])

print sep, "two libraries and a lib dir"
cc.link_shared_object ([cc.object_name('mymod'), cc.object_name('aux')],
                       cc.shared_library_name('mymod'),
                       ['stuff', 'junk'], ['/usr/local/lib'])

print sep, "add a 'built-in' lib dir and use it instead"
cc.add_library_dir ('/usr/local/lib')
cc.link_shared_object ([cc.object_name('mymod'), cc.object_name('aux')],
                       cc.shared_library_name('mymod'), ['stuff'])

print sep, "add some built-in auxiliary object files and a library"
cc.add_link_object ([cc.object_name('aux1'), cc.object_name('aux2'),
                     'resources.bin'])
cc.add_library ('stuff')
cc.link_shared_object ([cc.object_name('mymod')],
                       cc.shared_library_name('mymod'))
