#
# test_spawn.py
#
# test suite for distutils.util.spawn() (currently Unix-only)
#
# GPW 1999/07/20
#
# $Id: test_spawn.py,v 1.1.2.1 2000/04/05 00:20:58 gward Exp $
#

import sys
from distutils.spawn import spawn
from distutils.errors import *

spawn (["/bin/ls"])
print "ok: basic spawn with full path"

spawn (["ls"])
print "ok: basic spawn without full path"

# print "this will blow up, but I'll catch it:"
# try:
#     spawn (["ls"])
# except DistutilsExecError, msg:
#     print "caught DistutilsExecError: \"%s\"" % msg

# print "same again, but I'll wrap it in an eval for catching:"
# try:
#     eval ('spawn (["ls"])')
# except DistutilsExecError, msg:
#     print "caught DistutilsExecError: \"%s\"" % msg
    

#print "this should blow up:"
#spawn (["ls"])


try:
    spawn (["ls"], search_path=0)
except DistutilsExecError, msg:
    print "ok: spawn without full path, not searching path:", msg

spawn (["/bin/ls", "-l", sys.executable])
print "ok: spawn with args"

spawn (["/bin/ls", "-l", sys.executable], verbose=1)
print "ok: verbose spawn"

spawn (["/bin/ls", "-l", sys.executable], verbose=1, dry_run=1)
print "ok: verbose, dry-run spawn"

try:
    spawn (["/bin/ls", "aosjhfjhdsaf"])
except DistutilsExecError, msg:
    print "ok: spawn with bogus argument:", msg
    
try:
    spawn (["python", "-c", "import sys; sys.exit (123)"])
except DistutilsExecError, msg:
    print "ok: spawn depressed process:", msg

try:
    spawn (["python", "-c", "from os import *; kill (getpid(), 15)"])
except DistutilsExecError, msg:
    print "ok: spawn suicidal process:", msg
