#!/usr/bin/env python

# Setup script example for building the Numeric extension to Python.
#
# This example setup script is mainly of historical interest now, since
# Numerical Python now uses Distutils as its native build/install
# mechanism.  This version is a bit smaller than the "production"
# setup script included with NumPy, though, so might still be useful
# as an instructional example.

# created 1999/08 Perry Stoll

__rcsid__ = "$Id: numpy_setup.py,v 1.4 2000/01/30 15:42:53 gward Exp $"

from distutils.core import setup

setup (name = "numerical",
       version = "15.2",
       maintainer = "Paul Dubois",
       maintainer_email = "dubois@users.sourceforge.net",
       description = "Numerical Extension to Python",
       url = "http://numpy.sourceforge.net",

       packages = [''],
       package_dir = {'': 'Lib'},
       install_path = 'Numeric',
       include_dirs = ['Include'],
       ext_modules = [('_numpy',
                       { 'sources' : ['Src/_numpymodule.c',
                                      'Src/arrayobject.c',
                                      'Src/ufuncobject.c'],
                       }
                      ),

                      ('multiarray',
                       { 'sources' : ['Src/multiarraymodule.c'],
                       }
                      ),

                      ('umath',
                       { 'sources': ['Src/umathmodule.c'], }
                      ),

                      ('fftpack',
                       { 'sources': ['Src/fftpackmodule.c',
                                     'Src/fftpack.c'], }
                      ),

                      ('lapack_lite',
                       { 'sources' : ['Src/lapack_litemodule.c',
                                      'Src/dlapack_lite.c',
                                      'Src/zlapack_lite.c',
                                      'Src/blas_lite.c',
                                      'Src/f2c_lite.c'], }
                      ),

                      ('ranlib',
                       { 'sources': ['Src/ranlibmodule.c',
                                     'Src/ranlib.c',
                                     'Src/com.c',
                                     'Src/linpack.c'], }
                      )

                      ('arrayfns',
                       { 'sources': ['Src/arrayfnsmodule.c'],}
                       )
                     ]
       )
