#
# test_spawn.py
#
# test suite for distutils.util.spawn() (currently Unix-only)
#
# GPW 1999/07/20
#
# $Id: test_spawn.py,v 1.1 1999/09/29 13:10:23 gward Exp $
#

import sys
from distutils.spawn import spawn
from distutils.errors import *
from util import try_it

spawn (["/bin/ls"])
print "ok: basic spawn with full path"

spawn (["ls"])
print "ok: basic spawn without full path"

# print "this will blow up, but I'll catch it:"
# try:
#     spawn (["ls"])
# except DistutilsExecError, msg:
#     print "caught DistutilsExecError: \"%s\"" % msg

# print "same again, but I'll wrap it in an eval for catching:"
# try:
#     eval ('spawn (["ls"])')
# except DistutilsExecError, msg:
#     print "caught DistutilsExecError: \"%s\"" % msg
    

#print "this should blow up:"
#spawn (["ls"])


try_it ('spawn (["ls"], search_path=0)', DistutilsExecError,
        "spawn without full path, not searching path")

spawn (["/bin/ls", "-l", sys.executable])
print "ok: spawn with args"

spawn (["/bin/ls", "-l", sys.executable], verbose=1)
print "ok: verbose spawn"

spawn (["/bin/ls", "-l", sys.executable], verbose=1, dry_run=1)
print "ok: verbose, dry-run spawn"

try_it ('spawn (["/bin/ls", "aosjhfjhdsaf"])',
        DistutilsExecError, "spawn with bogus argument")
