# Test suite for distutils.fancy_getopt module

# $Id$

from string import split

from distutils.exceptions import *
from distutils.fancy_getopt import fancy_getopt

from util import test, try_it


class Dummy: pass
d = Dummy ()

tbl1 = [('verbose', 'v', "be noisy"),
        ('dry-run', 'n', "don't do anything")]
tbl2 = [('cflags=', None, "flags for C compiler"),
        ('cc=', 'c', "name of C compiler"),
        ('rpm', None, "build an RPM")]


# First, a simple and error-free command line
args = ['--verbose', '-n']
d = Dummy ()
r_args = fancy_getopt (tbl1, d, args)
test (r_args == [] and d.verbose and d.dry_run,
      "basic getopt")

# A wee bit more: abbreviate, and have one leftover
args = ['--verb', '-n', 'foo']
d = Dummy ()
r_args = fancy_getopt (tbl1, d, args)
test (r_args == ['foo'] and d.verbose and d.dry_run,
      "getopt with abbreviation and leftover")

# Now have a bunch of leftovers (most of which are actually options,
# but for a different option table)
args = split ('-v --dry-run cmd -c gcc --cflags=-O2')
r_args = fancy_getopt (tbl1, d, args)
test (r_args == ['cmd', '-c', 'gcc', '--cflags=-O2'] and
      d.verbose and d.dry_run,
      "getopt with leftovers")
d = Dummy ()
r_args = fancy_getopt (tbl2, d, r_args[1:])
test (r_args == [] and
      d.cc == 'gcc' and d.cflags == '-O2',
      "getopt on leftovers (command options)")

# Now put in some errors: should raise DistutilsArgError
args = ['--verbose=666', '-n', '-x']
d = Dummy ()
try_it ("fancy_getopt (tbl1, d, args)", DistutilsArgError,
        "getopt with bad command line blows up")

# A perfectly valid command line, but the wrong option table
args = ['-n', '--dry-run']
try_it ("fancy_getopt (tbl2, d, args)", DistutilsArgError,
        "right command line, wrong table blows up")

# Now some bogus option tables
tbl = [('x', None, 'oops!')]
try_it ("fancy_getopt (tbl, d, [])", DistutilsGetoptError,
        "bogus long option (too short) blows up")
tbl = [(None, 'x', 'oops!')]
try_it ("fancy_getopt (tbl, d, [])", DistutilsGetoptError,
        "bogus long option (not a string) blows up")
tbl = [('foo', 'foo', 'oops!')]
try_it ("fancy_getopt (tbl, d, [])", DistutilsGetoptError,
        "bogus short option (too long) blows up")
