#!/usr/bin/env python

# Setup script example for building the Numeric extension to Python.

# To use:
#   * copy or link this file to the Numerical directory of the LLNL 
#     distribution as "setup.py"
#   * rename (or copy, or link) Src/numpy.def to Src/_numpy.def
#   * run this to build Numerical Python:
#       python setup.py -v build
#     or this to build and install it
#       python setup.py -v install


# created 1999/08 Perry Stoll
__rcsid__ = "$Id: numpy_setup.py,v 1.2 1999/09/29 12:08:20 gward Exp $"

from distutils.core import setup

setup (name = "numerical",
       version = "11",
       maintainer = "Paul Dubois",
       maintainer_email = "dubois1@llnl.gov",
       description = "Numerical Extension to Python",
       url = "http://www.python.org/sigs/matrix-sig/",

       packages = [''],
       package_dir = {'': 'Lib'},
       install_path = 'Numeric',
       include_dirs = ['Include'],
       ext_modules = [('_numpy',
                       { 'sources' : ['Src/_numpymodule.c',
                                      'Src/arrayobject.c',
                                      'Src/ufuncobject.c'],
                       }
                      ),

                      ('multiarray',
                       { 'sources' : ['Src/multiarraymodule.c'],
                       }
                      ),

                      ('umath',
                       { 'sources': ['Src/umathmodule.c'], }
                      ),

                      ('fftpack',
                       { 'sources': ['Src/fftpackmodule.c',
                                     'Src/fftpack.c'], }
                      ),

                      ('lapack_lite',
                       { 'sources' : ['Src/lapack_litemodule.c',
                                      'Src/dlapack_lite.c',
                                      'Src/zlapack_lite.c',
                                      'Src/blas_lite.c',
                                      'Src/f2c_lite.c'], }
                      ),

                      ('ranlib',
                       { 'sources': ['Src/ranlibmodule.c',
                                     'Src/ranlib.c',
                                     'Src/com.c',
                                     'Src/linpack.c'], }
                      )
                     ]
       )
