"""install_ext

Implement the Distutils "install_ext" command to install extension modules."""

# created 1999/09/12, Greg Ward

__rcsid__ = "$Id: install_ext.py,v 1.2 1999/09/29 12:38:17 gward Exp $"

from distutils.core import Command
from distutils.util import copy_tree

class InstallExt (Command):

    options = [('install-dir=', 'd', "directory to install to"),
               ('build-dir=','b', "build directory (where to install from)"),
              ]

    def set_default_options (self):
        # let the 'install' command dictate our installation directory
        self.install_dir = None
        self.build_dir = None

    def set_final_options (self):
        self.set_undefined_options ('install',
                                    ('build_platlib', 'build_dir'),
                                    ('install_site_platlib', 'install_dir'))

    def run (self):

        # Dump the entire "build/platlib" directory (or whatever it really
        # is; "build/platlib" is the default) to the installation target
        # (eg. "/usr/local/lib/python1.5/site-packages").  Note that
        # putting files in the right package dir is already done when we
        # build.
        outfiles = self.copy_tree (self.build_dir, self.install_dir)

# class InstallExt
