#!/usr/bin/env python

"""Example setup.py for Fredrik Lundh's Imaging library (the PIL
   distribution)."""

# created 1999/09/19, Greg Ward

__rcsid__ = "$Id: pil_setup.py,v 1.4 1999/10/03 21:10:02 gward Exp $"

import os
from distutils.core import setup
from distutils.ccompiler import new_compiler


# Make sure the user has (configured and) built the C Imaging library.
# Take advantage of the Distutils bureaucracy to generate the filename
# of the library in a portable way.
compiler = new_compiler ()
lib_file = os.path.join ("libImaging", compiler.library_filename ("Imaging"))
if not os.path.isfile (lib_file):
    raise SystemExit, \
          "couldn't find %s -- did you configure and build the library?" % \
          lib_file

setup (name = "PIL",
       version = "1.0",
       description = "Python Imaging Library",
       author = "Fredrik Lundh",
       author_email = "fredrik@pythonware.com",
       url = "http://www.pythonware.com/downloads.htm",

       # Hmm, we don't install the sane module or PIL's "Scripts"
       # directory.  We could handle sane (in a slightly ugly way -- since
       # it's in a directory of its own, it would necessarily be the only
       # top-level module in the distribution), but Distutils as yet has no
       # facilities for installing scripts.

       packages = ['PIL'],
       ext_modules = \
           [('_imaging',
             { 'sources': ['_imaging.c', 'decode.c', 'encode.c',
                           'map.c', 'display.c', 'outline.c', 'path.c'],
               # This must include the directories with the JPEG,
               # zlib, and Tcl/Tk header files (if installed)
               'include_dirs': ['libImaging', '/usr/local/include'],

               # Keep this for Tcl/Tk support
               'macros': [('WITH_TKINTER', None)],

               # This must include the directories with the JPEG, zlib,
               # and Tcl/Tk libraries (whatever's available)
               'library_dirs': ['usr/local/lib'],

               # And this, of course, lists which of those external
               # libraries to link against (plus libImaging, which *must*
               # be included!)
               'libraries': ['libImaging/Imaging', 'jpeg', 'z', 'tcl8.0', 'tk8.0']
             }
           )]
      )
