#! /usr/bin/env python

# Copyright (c) 2001-2002 Python Software Foundation.  All rights reserved.
#
# This code is released under the standard PSF license.
# See the file LICENSE.

import os
from distutils.core import setup, Extension

if os.name == 'nt':
    SPREAD_DIR = r"\spread-bin-3.16.2"
    ext = Extension('spread', ['spreadmodule.c'],
                include_dirs = [SPREAD_DIR + r"\include"],
                library_dirs = [SPREAD_DIR + r"\win"],
                libraries = ['libtsp', 'wsock32'],
                extra_link_args = ['/NODEFAULTLIB:libc'],
                )
else:
    SPREAD_DIR = "/usr/local"
    ext = Extension('spread', ['spreadmodule.c'],
                include_dirs = [SPREAD_DIR + "/include"],
                library_dirs = [SPREAD_DIR + "/lib"],
                libraries = ['tsp'],
                )

setup(name = "Spread API for Python",
      ext_modules = [ext],
      )
