import java.sql.*;

public class DBConnection
{
    public DBConnection (String driver_class) throws Exception
    {
	// Load the JDBC driver
	Class.forName(driver_class).newInstance(); 
	instance = this;
    }

    public void login (String url,
		       String host,
		       String user,
		       String password,
		       String database) throws SQLException
    {
	// Connect to the database
	String url_str;
	url_str = new String (url + "://" + host + "/" + database);
	connection = DriverManager.getConnection (url_str, user, password);

	this.user = user;
	this.host = host;
    }

    public void login (String url,
		       String host,
		       String user,
		       String password) throws SQLException
    {
	login (url, host, user, password, "test");
    }

    public static DBConnection Instance ()
    {
	return instance;
    }

    public void dispose ()  throws SQLException
    {
	connection.close();
	connection = null;
    }

    protected void finalize () throws SQLException
    {
	if (connection != null)
	    {
		connection.close();
	    }
    }

    public Connection getConnection ()
    {
	return connection;
    }

    public String getUser()
    {
	return user;
    }

    public String getHost()
    {
	return host;
    }

    private static DBConnection instance = null;
    private Connection connection = null;
    private String user = "";
    private String host = "";
}














