package mysqladmin;


/** 

    t_connect is the connection-Object to the Database.
    I'm using it for the mySQL-stuff, but it works as well
    with other JDBC-Drivers.
    It in fact is something similar to the backbone of Admin.

    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.1 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

import java.io.*;
import java.net.URL;
import java.sql.*;
import java.util.Properties;
import java.util.Vector;




public class t_connect {

public Statement stmt;
public Connection con;
public String excpt, iJDBC, iURL;
private boolean dbg = false;


    /**
     * connect to the Database:
     * @host = a String that contains the DB-Server-hostname e.g. gotzenwil.eidberg.ch
     * @user = a String that represents the user as it is in the grant-table of the db
     * @password = a String that contains the users password: Attention: not encrypted,
     *             is going in plaintext over the network, (Yes, there is some room for improvement)
     * @database = the name of the database you want to connect to
     *
     * the JDBC-Driver stuff is in a property-file stored in the users -home-dir 
     * named: t_connect.props
     */
     

public t_connect (String host, String user, String password, String database) {

    Properties prop = new Properties();

    try {
	FileInputStream fip = new FileInputStream(System.getProperty("user.home")+File.separator+"t_connect.props");
	prop.load(fip);
    }
    catch (Exception ioex) {
       System.out.println("t_connect: can not load t_connect.props" + ioex + "\n using standard values");
       prop.put("JDBCdriver","org.gjt.mm.mysql.Driver");
       prop.put("JDBCurl","jdbc:mysql://");
       prop.put("DatabasePort","3306");
       prop.put("usePassword","yes");
       prop.put("DebugMode","off");
    }

 excpt = null;
 String url = "";
 int po = 0; 

 // are we in a debug mode
 if ( prop.getProperty("DebugMode").startsWith("on") ) dbg = true;

 if ( dbg ) {
   dbgMessage("JDBCdriver " + prop.getProperty("JDBCdriver"));
   dbgMessage("JDBCUrl " +  prop.getProperty("JDBCurl"));
   dbgMessage("DatabasePort " +  prop.getProperty("DatabasePort"));
   dbgMessage("usePassword " + prop.getProperty("usePassword"));
 }

 try
 {

     Class.forName(prop.getProperty("JDBCdriver"));
     url    = prop.getProperty("JDBCurl") ;

     iJDBC = prop.getProperty("JDBCdriver");
     iURL  = prop.getProperty("JDBCurl") ;


     // For non networked stuff set Port to 0
     try {
	 po = Integer.parseInt(prop.getProperty("DatabasePort"));
     } catch (NumberFormatException nfe) { 
	 po = 0; 
	 if ( dbg ) dbgMessage("not networked, no Port in use");
     }


     if (po > 0 ) {
	 if ( prop.getProperty("JDBCdriver").startsWith("oracle") ) {
	     url = url + user + "/" + password + "@" + host + ":" + prop.getProperty("DatabasePort") + ":" + database;
	     iURL = url;

	 } else {
	 url = url + host + ":" + prop.getProperty("DatabasePort") + "/" + database;
	 iURL = url;
	 }
     } else {
	 url = url + database;
	 iURL = url;
     }


     if ( dbg ) dbgMessage("URL: " + url);

     Properties p = new Properties();

      if ( ! prop.getProperty("JDBCdriver").startsWith("oracle") ) {

	  p.put("user",user);
	  if ( prop.getProperty("usePassword").equalsIgnoreCase("yes") ) {
	      p.put("password", password);
	  } 
	  con = DriverManager.getConnection(url,p);
      } else {
	  con  = DriverManager.getConnection(url);
      }
     stmt = con.createStatement();
  }
  catch (Exception e) {
  excpt = "Exception while opening "+ database + " on " + host + " : " + e.getMessage() + "\n" +
          "url: " + url;
  if ( dbg ) dbgMessage(excpt);

  }
  
}

public void close() {

 excpt = null;
 try
 {
  stmt.close();
  con.close();
  }
  catch (Exception e) {
  excpt = "Exception while closing databse: " + e.getMessage().toString();
  if ( dbg ) dbgMessage(excpt);
  }
}

public String getError() {

  return excpt;
 
}

    private void dbgMessage( String msg ) { System.out.println(msg); }

}
