
with Interfaces.C, Interfaces.C.Strings, Text_Io, Mysql_Ada;
with Ada.Command_Line;
use Interfaces.C, Interfaces.C.Strings, Mysql_Ada;

procedure Test_client is 

   use   type Interfaces.C.Strings.Chars_Ptr; 
   use   type Interfaces.C.Char_Array; 

   Default_Sql_Stmt : constant String            := "SELECT * FROM Db";
   Default_Db_Name  : constant String            := "mysql";
  
   Connect_Abort    :          exception;  
   Debug            :          Boolean           := False;  
   Szsql            :          String (1 .. 200);  
   Taille_Szsql     :          Integer;  
   Szdb             :          String (1 .. 50);  
   Taille_Szdb      :          Integer;  
   type Str_Rec is 
      record 
         Str  : String (1 .. 25) := (1..25 => Ascii.nul);  
         Last : Natural := 0;  
      end record; 
   Aszflds  : array (1 .. 25) of Str_Rec;  
   Pszt     : Chars_Ptr;  
   I,  
   J,  
   L        : Int; 
   U        : Unsigned;  
   X,y      : Integer;  
   My_Data  : Ptr_Mysql                  := null;  
   Res      : Ptr_Mysql_Res              := null;  
   Fd       : Ptr_Mysql_Field            := null;  
   Row      : Mysql_Row;  
   Longueur : Unsigned;  

   procedure To_Sz (
         A_String  : in     String; 
         Sz_String : in out String; 
         Last      :    out Natural ) is 
   begin
      Last :=0;
      for I in A_String'range loop
         Sz_String(I):=A_String(I);
         Last := Last +1;
      end loop;
   end;
   -- analogue a la fonction C
   procedure Str_Copy (
         My_Ptr      : in     Chars_Ptr; 
         Dest_String : in out String;    
         Last        : in out Natural    ) is 
      Some_String : constant String := Value (Item => My_Ptr);  
   begin
      if Some_String'Last < Dest_String'Last then
         Last :=Some_String'Last;
      else
         Last :=Dest_String'Last;
      end if;
      for I in 1..Last loop
         Dest_String (I) :=Some_String (I);
      end loop;
   end;

begin
      Taille_Szdb :=Default_Db_Name'Last;
      Szdb (1 ..Taille_Szdb) := Default_Db_Name;
      Taille_Szsql :=Default_Sql_Stmt'Last;
      Szsql(1..Taille_Szsql) := Default_Sql_Stmt;

   if Ada.Command_Line.Argument_Count > 0 then
      declare
        Current_Argument_Count : Natural :=1;
      begin  
      if Ada.Command_Line.Argument (Number => 1)="--debug" then
         Debug := True;
         Current_Argument_Count := 2;
      end if;
      if Ada.Command_Line.Argument_Count >= Current_Argument_Count then        
            To_Sz (
            A_String  => Ada.Command_Line.Argument (Number => 
            Current_Argument_Count), 
            Sz_String => Szdb,                                    
            Last      => Taille_Szdb);
            Current_Argument_Count :=Current_Argument_Count +1;
       end if;
 
     end;

   end if;



   Pszt := Mysql_Get_Client_Info;
   Text_Io.Put_Line( "Demarrage de MySQL Client version V" & Value
      (Item => Pszt));
   Text_Io.New_Line;
   Text_Io.Put_Line( "Taille de Mysql     =" & Integer'Image (Mysql
         'Size
         /8
         ));
   if Debug then
      Text_Io.Put_Line( "Taille de Net       =" & Integer'Image (Net
            'Size
            /8
            ));
      Text_Io.Put_Line( "Taille de Host      =" & Integer'Image
         (Chars_Ptr'Size/8));
      Text_Io.Put_Line( "Taille de Port      =" & Integer'Image
         (Unsigned'Size/8));
      Text_Io.Put_Line( "Taille de Thread_Id =" & Integer
         'Image
         (Unsigned_Long'Size/8));
      Text_Io.Put_Line( "Taille de Affected row ="
         & Integer'Image
         (Unsigned'Size/8
            ));
      Text_Io.Put_Line( "Taille de Status    =" & Integer
         'Image
         (Mysql_Status'Size/8
            ));

      Text_Io.Put_Line( "Taille de Field Alloc ="
         & Integer'Image (
            Mem_Root'Size/8
            ));
      Text_Io.Put_Line( "Taille de Options   =" & Integer
         'Image (Mysql_Option_S
            'Size/8
            ));
      Text_Io.New_Line;
   end if;

   My_Data :=Mysql_Init (Access_Mysql => My_Data
      );

   if (My_Data = null) then
      Text_Io.Put_Line("Impossible d'initialiser le client ..."
         );
      raise Connect_Abort;
   else
      Text_Io.Put_Line("Initialisation du client faite ..."
         );
      My_Data :=Mysql_Real_Connect (
        Access_Mysql => My_Data,                              
        Host         => New_Char_Array (Chars => Local_Host), 
        User         => Null_Ptr,                             
        Passwd       => Null_Ptr,                             
        Db           => Null_Ptr,                             
        Port         => Mysql_Port,                           
        Unix_Socket  => Null_Ptr,                             
        Clientflag   => 0);

      if (not (My_Data = null)) then
         if  (My_Data.Status = Mysql_Status_Ready) then
            Text_Io.Put_Line("Connecte au serveur")
               ;
         else
            Text_Io.Put_Line("Connexion impossible au serveur mysql sur le port :"
               & Integer'Image (Mysql_Port));
            raise Connect_Abort;
         end if;
      else
         Text_Io.Put_Line("Connexion impossible au serveur mysql sur le port :"
            & Integer'Image (Mysql_Port));
         raise Connect_Abort;
      end if;
   end if;

   I := Mysql_Select_Db (
     Access_Mysql => My_Data,                                      
     Db           => (New_String (Str => Szdb (1 .. Taille_Szdb)))
      );

   if (I /= 0) then
      Text_Io.Put_Line("Impossible de selectionner la base" &  Szdb
         (1 .. Taille_Szdb) );
      raise Connect_Abort;
   else
      Text_Io.Put_Line("La base " &  Szdb
         (1 .. Taille_Szdb) & " est selectionnee" );
   end if;

   Text_Io.New_Line;
   Text_Io.Put_Line("Requete :" &  Szsql(1..Taille_Szsql) & '|');
   Text_Io.New_Line;

   Longueur := Unsigned (Taille_Szsql) +1;
   I := Mysql_Real_Query (
     Access_Mysql => My_Data,                                       
     Q            => New_String (Str => Szsql (1 .. Taille_Szsql)), 
     Length       => Longueur
      );

 
   if I=0 then
      Res := Mysql_Store_Result (Access_Mysql => My_Data);
      if not (Res = null) then
--         Recherche du nombre de lignes trouvees
         I := Int(Res.Row_Count);
         Text_Io.Put_Line("Nombre de lignes trouvees :"
            & Integer'Image (Integer(I)));

--          .... Nous pouvons avoir les caracteristiques des champs  
         U :=Mysql_Field_Count ( Access_Mysql =>My_Data);
         X:= 0;
         for G in 1.. integer(U) loop
            Fd :=Mysql_Fetch_Field_Direct (Result => Res, Field_Nbr => unsigned (G));
            exit when (Fd=null);
            X := X+1;
         end loop;

         Text_Io.Put_Line("Nombre de champs trouves"
               & Integer'Image (X));

--          Recuperation et Affichage des lignes
         loop
            Row :=  Mysql_Fetch_Row (Result => Res);
            exit when (Row = null);
            J := Int(Res.Field_Count);

            for K in 1.. X loop
               Text_Io.Put_Line("champ N:"
                  & Integer'Image (K) & "  "&
                                    Aszflds (K).Str(1..
                                       Aszflds (K).Last) &
                                    " :" &
                  Value (Item => Row.all (K)));
            end loop;

         end loop;

         -- deallocation de la memoire  
         Mysql_Free_Result (Result => Res);
      end if;
   else
      Text_Io.Put_Line("Impossible d'executer " & Szsql (1 .. Taille_Szsql
            ) & " sur le serveur");

   end if;

   Text_Io.New_Line;
   Text_Io.Put_Line("=====  Diagnostic info ====="
      );
   Pszt := Mysql_Get_Client_Info;
   declare
      My_String : constant String := Value (Item => Pszt);  
   begin
      Text_Io.Put( "Client info     :" & My_String);
      Text_Io.New_Line;
   end;

   Pszt := Mysql_Get_Host_Info( My_Data );
   declare
      My_String : constant String := Value (Item => Pszt);  
   begin
      Text_Io.Put_Line( "Host info     :" & My_String);
   end;

   Pszt := Mysql_Get_Server_Info( My_Data ) ;
   declare
      My_String : constant String := Value (Item => Pszt);  
   begin
      Text_Io.Put_Line( "Serveur info    :" & My_String);
   end;

   Text_Io.New_Line;

   Res := Mysql_List_Processes (My_Data);

   if Res /= null then
            X:= 0;
            loop
               Fd :=Mysql_Fetch_Field (Result => Res);
               exit when (Fd=null);
               X := X+1;
               Str_Copy (
                    My_Ptr      => Fd.Name,         
                    Dest_String => Aszflds (X).Str, 
                    Last        => Aszflds (X).Last);
            end loop;
            y := 0;
            loop
               Row :=  Mysql_Fetch_Row (Result => Res);
               exit when (Row = null);
               Y := y+1;
               Text_Io.Put_Line("Processus #" & Integer'Image (y) & ":-");
               for K in 1.. X loop
                  if (Row.all (K)= null_ptr) then
                    Text_Io.Put_Line("champ #"
                    & Integer'Image (K) & "  ("&
                                    Aszflds (K).Str(1..
                                       Aszflds (K).Last) &
                                    ") : NULL"); 
                  else
                    Text_Io.Put_Line("champ #"
                    & Integer'Image (K) & "  ("&
                                    Aszflds (K).Str(1..
                                       Aszflds (K).Last) &
                                    ") :" &
                                Value (Item => Row.all (K)));
                  end if;
               end loop;
         end loop;
         Mysql_Free_Result (Result => Res);
   else
      Text_Io.Put_Line( "Erreur dans la liste des processus"
         );
   end if;

   Text_Io.New_Line;

   Res := Mysql_List_tables ( Access_Mysql => My_Data,
                              Wild  => New_String (Str=> "%"));
   X := 0;
   loop
        Fd := mysql_fetch_field( res ) ;
        exit when (Fd = null);
        X := X+1;
        Str_Copy (
                  My_Ptr      => Fd.Name,         
                  Dest_String => Aszflds (X).Str, 
                  Last        => Aszflds (X).Last);
   end loop;
   Y := 0;
   loop
       Row :=  Mysql_Fetch_Row (Result => Res);
       exit when (Row = null);

       Y := Y + 1 ;
       Text_Io.Put_Line("Table #" & Integer'Image (Y) & ":-");
       for K in 1.. x loop
           if (Row.all (K)= null_ptr) then
                    Text_Io.Put_Line("champ #"
                    & Integer'Image (K) & "  ("&
                                    Aszflds (K).Str(1..
                                       Aszflds (K).Last) &
                                    ") : NULL"); 
           else
                    Text_Io.Put_Line("champ #"
                    & Integer'Image (K) & "  ("&
                                    Aszflds (K).Str(1..
                                       Aszflds (K).Last) &
                                    ") :" &
                                Value (Item => Row.all (K)));
          end if;
       end loop;
   end loop;
 
   Mysql_Free_Result (Result => Res);

   Pszt := Mysql_Stat(Access_Mysql => My_Data) ;
   declare
      My_String : constant String := Value (Item => Pszt);  
   begin
      Text_Io.New_Line;
      Text_Io.Put_Line( My_String);
   end;

   Mysql_Close (Sock => My_Data);
exception
   when Connect_Abort =>
      Mysql_Close (Sock => My_Data);
end;
