<?php
/******************************************************
* Script Name: seqmrtg.php 0.1v
* By : Mirsad Dedovic (mdedovic@cortexbytes.net)
* Description : I created this low tech script to help
* me create mrtg configuration for device like switches
* with a lot of ports. 
*
* Usage: configure the variables in this script and 
*        execute the script either by executing it
*        from shell 'php seqmrtg.php', or by running
*        the script from your web browser.
*        Note: make sure there are appropriate permissions
*        for the script to create the output file.
*        This script also creates html code that can be used
*        to create an index page for all the devices.
*
* License: Script is free for anyone to modify and use.
*          If you improve this script please drop me a
*          message with your version.
*
******************************************************/
####################################################################
# BEFORE YOU BEGIN
# -----------------
# This script was not intended to make it easier for you to 
#  setup mrtg. It is meant to speed up the configuration for
#  Switches or Routers with a lot of identical devices.
# If you're not familiar with MRTG configuration you shouldn't be 
#  using this script it will only make it harder for you.
####################################################################

########### Settings ###############


#Specify the name of the file where you would like the configuration
# to be written to. (I usually add this file to my mrtg configuration
# 'cat output.txt >> mrtg.cfg'). I also backup my original mrtg.cfg
# in case I make a mistake or I want to change something in the future.

 $filename = "output.txt";

#This script also makes an html file that you can use to
# create a nice index page for all the devices mrtg is monitoring.
# This file will only contain raw html, preferably you would add
# the html headers and customize the html page to your taste.

 $filename2 = "index.html";

#Image extension your MRTG version uses.
# Most recent versions use .png for their graph files.
# So you should be fine with the default setting.

 $imgext = ".png";

#Octets_in string (last number omitted)
# in this example I want to be able to log "Octets_In" 
# This setting represents the MIB string I use. Last number
# will be generated by this script. (1.3.6.1.2.1.2.2.1.10.*)
# 

 $octets_in_template = "1.3.6.1.2.1.2.2.1.10.";

#Octets_out string (last number omitted)
# (same as above)

 $octets_out_template = "1.3.6.1.2.1.2.2.1.16.";

#Creation range
# This has to do with two previous settings.
# Basically in this example I want to create MRTG configuration entry for 48 interfaces.
# So the output.txt file will contain 48 MRTG configuration entries of the target range (1.3.6.1.2.1.2.2.1.10.9-57)
# and (1.3.6.1.2.1.2.2.1.16.9-57)
#
 $start_from = 9;
 $end_at = 57;

# Adjust port name to interface name
# in my case the switch I was configuring the interface 9 was actually port 1
# so I used this setting to adjust the name of the port.

 $adjust_port = -8;

#MRTG html file name (number added)
# Every interface monitored my MRTG has to have it's unique name.
# this script will generate name specified here and it will add it a number at the end.
# eg. sw1ptr1.html - sw1ptr48.html

  $html_name = "sw1prt";

#Title (number added)
# same as above this is just a description. The number will be added at the end
# of these settings for every interface/html page MRTG creates.

  $title = "Bandwidth usage graph for switch 1 port : ";
  $page_top = "Status for port : ";

#Options
# This setting allows you to add options to the MRTG configuration created
# by this script using MRTG's Options directive.

 $options = "bits";


#Read Community
# read community of the device.

 $community = "Public";


#Host 
# host of the device.

 $host = "device.domain.com";


#Max Bytes
# For MRTG's Max_Bytes directive.

 $maxbytes = 12500000;

########### End of settings ###############


########### Script Starts Here ###############
`rm -f $filename`;
`rm -f $filename2`;

$file = fopen($filename, "a");
$file2 = fopen($filename2, "a");

for ($i = $start_from; $i <= $end_at; $i++){
 $buffer = "";
 $j = $i + $adjust_port;
 $buffer .= "Target[" . $html_name . $j ."]: " . $octets_in_template;
 $buffer .= $i . "&" . $octets_out_template . $i . ":" . $community . "@";
 $buffer .= $host . "\n";
 $buffer .= "MaxBytes[" . $html_name . $j ."]: " . $maxbytes . "\n";
 $buffer .= "Title[" . $html_name . $j ."]: " . $title . " $j\n";
 $buffer .= "PageTop[" . $html_name . $j . "]: <H1>" . $page_top . " $j</H1>\n";
 $buffer .= "Options[" . $html_name . $j . "]: " . $options . "\n";
 $buffer .= "\n";
 
 echo $buffer;
 fputs ($file, $buffer);

 $buffer2 = "";
 $buffer2 .= "<br>\n<font face=\"Tahoma, Arial\" size=\"1\">$title $j</font><br>\n";
 $buffer2 .= "<a href=\"$html_name$j.html\"><img src=\"" . $html_name . $j ."-day" . $imgext;
 $buffer2 .= "\" border=0></a><hr>\n<br>";
 
 fputs ($file2, $buffer2);
}

fclose ($file);
fclose ($file2);

?>
