/* Creation of an HTML file with the image generated previously (mkpic.c)
   and a map from information in config file.
   Parameters are read from the config file in the same format as mrtg.cfg.
   L. Derrien 19/8/99
   Update LD  20/10/00 : processing of multiple netmaps.
   Update LD  14/02/01 : "grapher" for links to CGI or different directory...
*/ 

#include <stdio.h>
#include <time.h>

/* WATCOM C/C++ 10.6 under Win95/NT */
/* VC++ 6.0 under Win95/NT */
#if defined(__WATCOMC__) || defined(WIN32)
#include <string.h>
#include <sys\types.h>
#include <direct.h>
#include <io.h>
#endif

#include "cfg.h"

/* JavaScript functions to display the countdown before next update... */
#ifndef NOJS

#define COUNTDOWN "\n<script language=\"JavaScript\"> \n\
<!-- \n\
startday = new Date(); \n\
clockStart = startday.getTime(); \n\
\n\
function initStopwatch(tms) \n\
{ \n\
 var myTime = new Date(); \n\
        var timeNow = myTime.getTime(); \n\
        var timeDiff = tms - (timeNow - clockStart); \n\
        if (timeDiff>0) this.diffSecs = timeDiff/1000; \n\
	else this.diffSecs = 0; \n\
        return(this.diffSecs); \n\
} \n\
\n\
function getSecs(delai) \n\
{ \n\
        var mySecs = initStopwatch(delai*1000); \n\
        var mySecs1 = \"\"+mySecs; \n\
        mySecs1= mySecs1.substring(0,mySecs1.indexOf(\".\")) + \" secs.\"; \n\
        document.form1.timeleft.value = mySecs1; \n\
        window.setTimeout('getSecs(%d)',1000); \n\
} \n\
//--> \n\
</script>\n"

#endif

/* Process the current date to get 
   the string displayed at the end of the HTML page
   and the Expires META date */
void comp_date(int refresh, char *strnow, char *strnext, int lg)
{
#if HAVE_STRFTIME
  time_t NOW;
  struct tm *nowtm;

  tzset();   
  time(&NOW);
  nowtm=localtime(&NOW);

#ifdef FR
  strftime(strnow, lg, "Mis &agrave; jour le :<BR><BR> %d/%m/%y %X", nowtm);
#else
  strftime(strnow, lg, "Last update :<BR><BR> %x %X", nowtm);
#endif

  /* Next refresh time used in the Expires META */
  NOW += refresh;
  nowtm=gmtime(&NOW);
  strftime(strnext, lg, "%a, %d %b %Y %X GMT", nowtm);
#else
  lg=0; strnow[0]=strnext[0]='\0';
#endif
}       


/* Make the HTML page for netmap NMap */
void mk_html(netmap *NMap) 
{
  FILE *fhtml, *fareas;
  char str[120], sufx[6]="";
  char lastch;
  int i;
  char nowtime[50], expirtime[50];
  htmlarea *ptrarea;

/* printf("Indexmap : %s title : %s pagehead : %s\n", NMap->HtmlFile, NMap->HtmlTitle, NMap->HtmlPageHeader); */
       
  if (strlen(NMap->HtmlTitle)==0 && strlen(NMap->HtmlPageHeader)==0) return;
  
  sprintf(str, "%s/%s", NMap->WDir, NMap->HtmlFile);  

  if ((fhtml=fopen(str, "w")) == NULL) {
        fprintf(stderr, "Error creating the HTML file %s\n", str);
        return;
  }      

  comp_date(NMap->refresh, nowtime, expirtime, 50);

  fprintf(fhtml, "<HTML>\n<HEAD>\n<TITLE>%s</TITLE>\n", NMap->HtmlTitle);
  fprintf(fhtml, "<META HTTP-EQUIV=\"Refresh\" CONTENT=\"%d\">\n", NMap->refresh);
  fprintf(fhtml, "<META HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">\n");
  if (strlen(expirtime)>0)
    fprintf(fhtml, "<META HTTP-EQUIV=\"Expires\" CONTENT=\"%s\">\n", expirtime);
  fprintf(fhtml, "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\"; charset=iso-8859-1>\n");

#ifndef NOJS
  fprintf(fhtml, COUNTDOWN, (NMap->refresh));
#endif  

  /* Definition of the areas for the image map */
  fprintf(fhtml, "<MAP NAME=\"mrtglnk\">\n");

  ptrarea = NMap->LAreas;  
  while (ptrarea) {
  	if (strcmp(NMap->grapher, "")==0) strcpy(sufx, ".html");
  	else {
  		lastch=(char)(NMap->grapher[strlen(NMap->grapher)-1]);
  		if (lastch == '/' || lastch == '\\') strcpy(sufx, ".html");
  	}
  	fprintf(fhtml, "<area href=\"%s%s%s\" alt=\"%s\" shape=\"%s\" coords=\"%s\">\n",
		NMap->grapher, ptrarea->nameref, sufx, ptrarea->nameref, 
		(ptrarea->areatyp)?"rect":"poly", ptrarea->areastr);
        ptrarea = ptrarea->nextarea;
  }  
  
  /* Read the areas defined in the file areasdef... */
  if (strlen(NMap->areasdef)>0) {
        sprintf(str, "%s/%s", NMap->WDir, NMap->areasdef);
        if ((fareas=fopen(str, "r")) != NULL) {
                while (fgets(str, 120, fareas))
                        fprintf(fhtml, str);
                fclose(fareas);
        }
  }

  /* Body of the HTML page */
  fprintf(fhtml, "</MAP>\n</HEAD>\n<BODY BGCOLOR=\"#ffffff\""); 
#ifndef NOJS 
  fprintf(fhtml, " onLoad=\"window.setTimeout('getSecs(%d)',1)\">\n", NMap->refresh);
#else
  fprintf(fhtml, ">\n");
#endif

  fprintf(fhtml, NMap->HtmlPageHeader);

  fprintf(fhtml, "<BR><P ALIGN=CENTER>\n");

  fprintf(fhtml, "<IMG VSPACE=10 SRC=\"%s\" BORDER=0 USEMAP=\"#mrtglnk\" ISMAP><BR>\n", NMap->pngout);

#ifdef FR
  fprintf(fhtml, "\n<FONT SIZE=-1><i>Cliquez sur des zones de la carte du r&eacute;seau pour obtenir des stats d&eacute;taill&eacute;es.</i></FONT><BR>\n");
#else
  fprintf(fhtml, "\n<FONT SIZE=-1><i>Click upon network map areas to get MRTG detailed stats.</i></FONT><BR>\n");
#endif

  fprintf(fhtml, "</P>\n<TABLE WIDTH=\"100%%\" BORDER=0 CELLPADDING=4 CELLSPACING=0>\n");
  fprintf(fhtml, "<TR><TD ALIGN=LEFT VALIGN=TOP WIDTH=30%%>%s</TD>\n", nowtime);  
  fprintf(fhtml, "<TD ALIGN=CENTER WIDTH=40%%>\n");
#ifdef FR
  fprintf(fhtml, "<FONT SIZE=-1>Utilisation :</FONT><BR>\n");
#else
  fprintf(fhtml, "<FONT SIZE=-1>Usage :</FONT><BR>\n");
#endif
  for (i=0; i<NLEVEL; i++) {
  	fprintf(fhtml, "<FONT SIZE=-1 COLOR=\"#%2x%2x%2x\">", levcolor[i].r, levcolor[i].g, levcolor[i].b);
#ifdef FR
  	fprintf(fhtml, "De %3d &agrave; %3d %%", i*100/NLEVEL, (i+1)*100/NLEVEL);
#else
  	fprintf(fhtml, "From %3d to %3d %%", i*100/NLEVEL, (i+1)*100/NLEVEL);
#endif
	fprintf(fhtml, "</FONT><BR>\n");
  }
  fprintf(fhtml, "</TD>\n");
#ifdef FR
  fprintf(fhtml, "<TD ALIGN=RIGHT VALIGN=TOP WIDTH=30%%>Actualisation dans");
#else
  fprintf(fhtml, "<TD ALIGN=RIGHT VALIGN=TOP WIDTH=30%%>Next update in");
#endif

#ifndef NOJS
  fprintf(fhtml, "<form name=form1><input size=9 name=timeleft></form>\n");
#else
  fprintf(fhtml, "<BR><BR>%.1f minutes</TD>\n", (float)(NMap->refresh)/60.0);
#endif

  fprintf(fhtml, "</TR></TABLE>\n");

#ifndef NOSIGN
  fprintf(fhtml, "<SPACER TYPE=VERTICAL SIZE=3><HR>\n");

  fprintf(fhtml, "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%%\">\n");
  fprintf(fhtml, "<TR VALIGN=top>\n");
  fprintf(fhtml, "<TD WIDTH=\"50%%\" ALIGN=LEFT><FONT FACE=\"Arial,Helvetica\" SIZE=2>PICNET v%s</FONT></TD>\n", VERSION);
  fprintf(fhtml, "<TD WIDTH=\"50%%\" ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>\n");
  fprintf(fhtml, "Laurent Derrien <A HREF=\"mailto:derrien@canl.nc\">derrien@canl.nc</A>\n"); 
  fprintf(fhtml, "</TD>\n</TR>\n</TABLE>\n");
#endif

  fprintf(fhtml, "</BODY>\n</HTML>\n");
  fclose(fhtml);
  return;
}

/* Make all the HTML pages */
void mk_htmlpages() 
{
  netmap *ptr = LMap;

  while (ptr) { 
	mk_html(ptr);
	ptr = ptr->nextmap;
  }
}