/* MAIN : Create a PNG image from a reference PNG image replacing colors of
   links by colors depending on the current traffic rate.
   Then, create an HTML page with the image just created. This image is an
   image map indexing stats pages generated by MRTG.
   The config file format is the same as MRTG one.
   L. Derrien 20/8/99
   Update LD  20/10/00 : Add the processing of many images hierarchicaly.
*/


#include <stdio.h>

/* WATCOM C/C++ 10.6 under Win95/NT */
/* VC++ 6.0 under Win95/NT */
#if defined(__WATCOMC__) || defined(WIN32)
#include <sys\types.h>
#include <direct.h>
#include <io.h>
#endif

#include "mkpic.h"
#include "mkhtml.h"


int main(int argc, char **argv)
{ 
  if (argc != 2) {
	fprintf(stderr, "\nUsage: %s <config-file>\n", argv[0]);
	fprintf(stderr, "\nDisplay your network traffic on an image.\n");
	fprintf(stderr, "It must be used with MRTG...\n");
	fprintf(stderr, "\nPlease read the docs for more information !\n");
  	exit(1);
  }   
  
  if (!loadcfg(argv[1])) exit(1);
/*  printf("Cfg OK\n"); */
  
  comp_netmaps();
/*  printf("NetMaps OK\n"); */
  
  mk_htmlpages();
/*  printf("HTML OK\n"); */
  
  FreeLMap();
  
  exit(0);
}