package ch.swisslife.ibgm.mc2;
import java.awt.*;
import java.awt.event.*;

/**Info or error dialog with OK button. 
 *
 * @author	David Flanagan, O'Reilly & Associates
 * @author	Michael Grob for RA/SL, minor changes
 * @version	1.01, 09/04/98
 */
public class WarnDialog extends Dialog implements ActionListener, WindowListener {
	protected Button button;
	protected MultiLineLabel label;
	Frame f;

	
	/**Constructor with title and message and a frame.
	 *
	 * @param title		String containing the Title of the dialog
	 * @param message	String with the message of the dialog
	*/
	public WarnDialog (Frame parent, String title, String message) {
		this.super(parent, title, false);
	
		this.setLayout(new BorderLayout(15,15));
		this.setBackground(Color.lightGray);

		label = new MultiLineLabel(message, 20, 20);
	
		this.add("Center", label);

		//OK button in a panel

		button = new Button("OK");
		Panel p = new Panel();
		p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));
		p.add(button);
		this.add("South", p);
		button.addActionListener(this);
		this.addWindowListener(this);

		this.pack();
	}


	/** Closes window if button is pressed.
	 *
	 * @param event		Event received by the button
	 */
	public void actionPerformed(ActionEvent event) {
			this.setVisible(false);
			this.dispose();
	}


	/** Closes window if button is pressed.
	 *
	 * @param event		Event received by the button
	 */
	public void windowClosing(WindowEvent e) {
			this.setVisible(false);
			this.dispose();
	}


	public void windowOpened(WindowEvent e) {
	}

	public void windowClosed(WindowEvent e) {
	}


	public void windowIconified(WindowEvent e) {
	}

	public void windowDeiconified(WindowEvent e) {
	}

	public void windowActivated(WindowEvent e) {
	}

	public void windowDeactivated(WindowEvent e) {
	}

	/** Main method with title and message as argument. Class should be used with a call to main().
	 */
	public static void main(String[] argv) {
	}
}







