package ch.swisslife.ibgm.mc2;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.util.StringTokenizer;

/** Implements an input channel as an interface between applet and cgi script.
 * It communicates with the cgi script over the following protocoll:
 * <code>Target=XXXXXXXXXXXXXXX\n
 * option1= YYYYYYYYYYYYYYY\n
 * option2=ZZZZZZZZZZZZZZZ\n</code>
 * and so on...
 * It means that first comes the Target name and then all the entries for each target.
 * So it is always clear which target is active. The procotol is human readable, which makes it 
 * easier to debug. 
 * It uses a URLConnection for the communication, which means that the data is transfered as 
 * plain text from the web server. This class parses it, creates a Cfg object an fills the data in.
 * 
 * @author	Michael Grob for RA/SL
 * @version 	1.01, 09/04/98/
 */
public class InputChannel {

	// some constants
	public String URL_OF_CGI;
	private Cfg file;
	private int current = 0;	//which target is active

	/** Constructor for the InputChannel. Instantiates a Cfg file.
	 *
	 * @param Workdir	String containing the WorkDir
	 * @param Icondir	String containing the IconDir
	 */
	public InputChannel(String cfgreader, String workdir, String icondir) {
		this.super();
		file = new Cfg(workdir, icondir);
		URL_OF_CGI = cfgreader;
	}
	
	/**Gets the data from the cgi and feeds it into cfg file
	 *
	 * @param device	String to determine if a device or file is to be inspected
	 * @param url		String with the name or url of the devce/file
	 * @return		Cfg with all the data in it
	 */
	public Cfg getFromCgi(String device, String url) {
		// build the url
		String nextline;
		
		String cgi_url = this.URL_OF_CGI + "?" + device + "=" + url;
		// connection to server
		
		try {
			// call cgi
			URL UrlOfCgi = new URL(cgi_url);
			URLConnection ConnectionOfURL = UrlOfCgi.openConnection();
			ConnectionOfURL.setUseCaches(false);
			// open input stream
			BufferedReader Input = new BufferedReader( new InputStreamReader(ConnectionOfURL.getInputStream()));
			
			// read line and tokenize it
			while((nextline = Input.readLine()) != null) {
				String token[] = this.tokenize(nextline);
				if (nextline.length() > 3) {

					if (token[0].equals("Target")) {
						current = file.newTarget(token[1]);
					}
					else if (token[0].equals("WorkDir")) {
						if (file.setValue("WorkDir", token[1]) == false) {
							AWTHelper.warn("couldn't setValue " + current + token[0] + token [1]);
						}
					}
					else if (token[0].equals("IconDir")) {
						if (file.setValue("IconDir", token[1]) == false) {
							AWTHelper.warn("couldn't setValue " + current + token[0] + token [1]);
						}
					}
					else if (token[0].equals("Refresh")) {
						if (file.setValue("Refresh", token[1]) == false) {
							AWTHelper.warn("couldn't setValue " + current + token[0] + token [1]);
						}
					}
					else if (token[0].equals("Interval")) {
						if (file.setValue("Interval", token[1]) == false) {
							AWTHelper.warn("couldn't setValue " + current + token[0] + token [1]);
						}
					}
					else { if (file.setValue(current, token[0], token[1]) == false) {
							AWTHelper.warn("couldn't setValue " + current + token[0] + token [1]);
						}
					}
				}
			}
		}
		catch (MalformedURLException e) {
			AWTHelper.warn("Badly formed URL: " + e);
		}
		catch (IOException e) {
			AWTHelper.warn("I/O Error: " + e);
		}
		catch (SecurityException e) {
			AWTHelper.warn("Security Exception: " + e);
		}
		// anything seems to be ok...
		return file;
	}	
				
					
	/** Tokenizes  line of the input data.
	 * 
	 * @param line	String which will be tokenized; the input line
	 * @ return	A String[] Array with 2 elements with the tokens in them; token[1] and token[2]		
	 */		
	private	String[] tokenize(String line) {
		// splits the line in 2 tokens
		String[] token;
		token = new String[2];
		StringTokenizer tok = new StringTokenizer(line, "==");
		if (tok.hasMoreTokens()) {
			token[0] = tok.nextToken().trim();
		}
		else { AWTHelper.warn("Tokenizer: no more Tokens at line " + line);
		}
		if (tok.hasMoreTokens()) {
			token[1] = tok.nextToken().trim();		
		}
		else { token[1] = "";
		}
		return token;
	} 	
}
