#!/usr/bin/perl

# ============================================================================
#
#    File:    get_remote_data.pl
#    Author:  Erwin Horjus | erwin.horjus@virgil.nl
#    Version: 1.0
#
#    Date:    24/6/2003
#    Purpose: This script is used to establish a TCP connection with
#             a host to get the output of a program on that remote host.
#
#    Usage:   get_remote_data.pl <hostname>
#
#    Info:    Designed on Solaris 8 with perl version 5.6.1
#             The script itself has only been tested on sun.
#
#    History:
#             24/6/2003 - Initial build by Erwin Horjus
#
# ============================================================================

use Net::Telnet;

$hostname = $ARGV[0];
$port = 9048;
$expected_lines= 4;

# This checks for options passed from the commandline
if (scalar(@ARGV) < 1)
   {
   print("Usage: $0 <hostname> \n");
   exit(-1);
   }

if ($ARGV[0] ne '' && $ARGV[0] ne '#')
   {
   $hostname = $ARGV[0];
   }

$t = new Net::Telnet ( Host => $hostname, Port => $port);
$t->open("$hostname");

print $t->get(Timeout => 20);
