/* vim: set sw=8 ts=8 si et: */

/*
 * Author: Guido Socher (guido(at)linuxfocus.org). This program is distributed
 * under the terms of the Gnu Public License (GPL).
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <gtk/gtk.h>


static GtkWidget *mw_txt_label1;
static GtkWidget *mw_txt_label2;

static gint run_cmd_pipe(const char *command) {
        FILE *f;
        char c;
        char line[2][30];
        int whichline=0;
        int i=0;

	line[0][0]='\0';
	line[1][0]='\0';
        f=popen(command,"r");
        if (!f){
                g_warning("i2ctempgui: could not open pipe\n");
                return (FALSE);
        }
        while (1) {
                c =(char) getc(f);
                if (c == EOF) {
                        break;
                }
                if (c == '\n' || c == '\r'){
                        line[whichline][i]='\0';
                        if (i && whichline == 0){
                                whichline=1;
                                i=0;
                        }
                        if (i && whichline == 1){
                                break;
                        }
                        continue;
                }
                if (i<30){
                        line[whichline][i]=c;
                        i++;
                }
        }
        line[whichline][i]='\0';
        pclose(f);
        gtk_label_set(GTK_LABEL(mw_txt_label1),line[0]);
	if (line[1][0]){
		gtk_label_set(GTK_LABEL(mw_txt_label2),line[1]);
	}
        return (TRUE);
}


/*
 * quit the whole application
 */
static void byebye(GtkWidget * widget, gpointer data){
	gtk_exit (0);
}

int main(int argc, char *argv[]){

	GtkWidget *mainwindow;
	GtkWidget *vbox,*labelbox1,*labelbox2;

	/* parse GTK command line and take out gtk args. The rest is
         * still in argv[] */
	gtk_init(&argc, &argv);
	
	mainwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	/* minimum size */
	gtk_widget_set_usize( GTK_WIDGET(mainwindow), 65, 40);
	gtk_window_set_title( GTK_WINDOW(mainwindow), "i2ctemp");
	/* handle delete_event, usually by the 'close' option */
	gtk_signal_connect(GTK_OBJECT(mainwindow), "delete_event",
		GTK_SIGNAL_FUNC(byebye), NULL);
        gtk_signal_connect(GTK_OBJECT(mainwindow), "destroy",
                GTK_SIGNAL_FUNC(byebye), NULL);
	
	/* set up the boxes to do the packing: */
	vbox = gtk_vbox_new(FALSE,1); /* 0=no border, 1=border */
        gtk_container_add(GTK_CONTAINER (mainwindow), vbox);

	/* the text in the main window */
	mw_txt_label1 = gtk_label_new("no temp ");
        gtk_label_set_justify(GTK_LABEL(mw_txt_label1),GTK_JUSTIFY_LEFT);
	labelbox1 = gtk_hbox_new(FALSE, 0);
	mw_txt_label2 = gtk_label_new("no temp ");
        gtk_label_set_justify(GTK_LABEL(mw_txt_label2),GTK_JUSTIFY_LEFT);
	labelbox2 = gtk_hbox_new(FALSE, 0);
	/* make the lable big enough by putting a box arround it
         * the hight does not matter as it is minimum size values: */

	gtk_widget_set_usize(GTK_WIDGET(labelbox1),45,15);
	gtk_widget_set_usize(GTK_WIDGET(labelbox2),45,15);
	/* pack: expand, fill, padd 4*/  
	gtk_box_pack_start(GTK_BOX(vbox), labelbox1, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), labelbox2, TRUE, TRUE, 0);
        /* put the label into the box: */
	gtk_container_add(GTK_CONTAINER (labelbox1), mw_txt_label1);
	gtk_widget_show(mw_txt_label1);
        gtk_widget_show(labelbox1);
	gtk_container_add(GTK_CONTAINER (labelbox2), mw_txt_label2);
	gtk_widget_show(mw_txt_label2);
        gtk_widget_show(labelbox2);

        /* get the first i2c temp reading */
        run_cmd_pipe("i2ctemp_linux");

        /* every 100 seconds we check if the interface ppp is up*/
        gtk_timeout_add( 100000,(GtkFunction)run_cmd_pipe,(gpointer) "i2ctemp_linux");

	/* yeaaaaa GUI is ready */
	gtk_widget_show(vbox);
	gtk_widget_show(mainwindow);

	/* go to main loop */
	gtk_main();
	return 0;
}

