#ifndef LAYOUT_H
#define LAYOUT_H

#define KEYCAP_PADDING 2   // number of spaces between keycap tokens

#define CREDITS_HEIGHT 4
#define CREDITS_WIDTH 14

#define DISTANCE_INPUT_FROM_BOTTOM 1  // take input on the bottom of the screen.

#define GAP_BETWEEN_X_AND_INPUT 1  // A single blank line between bottom of stack and input line

#define GAP_BETWEEN_STACK_AND_KEYPAD 2  // two blank lines below the keypad

#define MEMORY_SHORTER_THAN_STACK 2  // show two fewer memory elements than stack elements

#define HORIZ_SPACE_STACK_TO_MEMORY 3  // gap between stack and memory displays

#define HORIZ_SPACE_LEFT_OF_NUMPAD 4  // gap between memory and numpad

#define PROGRAM_INDENT 5  // program display indented 5 from left margin

#define STEP_WINDOW_SIZE 3  // Size of a stepping window

#define GAP_BETWEEN_PROG_AND_KEYPAD 1  // space between program listing and keypad

#define GAP_BETWEEN_PROG_AND_INPUT 1  // space between program listing and input line

#define NUMPAD_WIDTH  12
#define NUMPAD_HEIGHT  4

#endif  /* !LAYOUT_H */
