// The command line parser for options to the HP-67 program.


#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>

#include "hpglobals.h"


static void usage(char *exename)
#ifdef __GNUC__
__attribute__ ((noreturn))
#endif  /* __GNUC__ */
;


static void usage(char *exename)
{
  fprintf(stderr, "\nHP67 calculator emulator.\n");
  fprintf(stderr, "By Christopher Neufeld.\n\n");
  fprintf(stderr, "Usage:\n");
  fprintf(stderr, "       %s [options]\n", exename);
  fprintf(stderr, "       --noexit,-n                  Disable CTRL-D termination of HP67.\n");
  fprintf(stderr, "       --program=program,-p program Preload this program file.\n");
  fprintf(stderr, "       --ignorercfile,-i            Don't preload rc program.\n");
  fprintf(stderr, "       --help,-h                    Print this message and exit.\n");
  fprintf(stderr, "\n");
  exit(EXIT_FAILURE);
}


void parse_options(int argc, char **argv)
{
  int alldone;
  static struct option long_options[] = {
    { "noexit", no_argument, NULL, 'n' },
    { "program", required_argument, NULL, 'p' },
    { "ignorercfile", no_argument, NULL, 'i' },
    { "help", no_argument, NULL, 'h' },
    { NULL, 0, 0, 0 }
  };

  alldone = 0;
  
  while (!alldone) {
    
    switch(getopt_long(argc, argv, "np:ih", long_options, NULL)) {
    case -1:
      alldone = 1;
      break;
    case 'n':
      if (noexit)  /* Already seen this option. */
	usage(argv[0]);
      noexit = 1;
      break;
    case 'p':
      if (preload != NULL)
	usage(argv[0]);   /* Already seen this option */
      preload = optarg;
      break;
    case 'i':
      if (ignorerc)
	usage(argv[0]);   /* Already seen this option */
      ignorerc = 1;
      break;
    case 'h':
      usage(argv[0]);
    default:
      usage(argv[0]);
      break;
    }
  }
}


char *get_environment_preload(void)
{
  char *filename;
  FILE *testok;

  filename = getenv(PRELOADENVVAR);
  if (filename == NULL)
    return NULL;

  testok = fopen(filename, "r");
  if (testok == NULL)
    filename = NULL;
  else
    fclose(testok);

  return filename;
}


/* I realize there's a potential memory leak here if this function is
 * called more than once. */
char *get_rcfile_preload(void)
{
  char *homedirname;
  static char *filename;
  int bufflen;
  FILE *testok;
  int addslash;
  static int beenherebefore = 0;

  if (beenherebefore)
    fprintf(stderr, "Warning! Possible memory leak. get_rcfile_preload() called more than once.\n");

  beenherebefore = 1;
  homedirname = getenv(HOMEENVVAR);
  if (homedirname == NULL)
    return NULL;

  addslash = 0;
  bufflen = strlen(homedirname);
  if (homedirname[bufflen-1] != '/')
    addslash = 1;

  bufflen += strlen(RCFILENAME);

  filename = (char *) malloc((bufflen + addslash) * sizeof(char));
  strcpy(filename, homedirname);
  if (addslash)
    strcat(filename, "/");
  strcat(filename, RCFILENAME);

  testok = fopen(filename, "r");
  if (testok == NULL) {
    free(filename);
    filename = NULL;
  } else
    fclose(testok);

  return filename;
}
