/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class Graph
extends Canvas
implements MouseListener,
MouseMotionListener {
    private GCalc host;
    private Image image;
    private Graphics page;
    public boolean axis;
    public boolean dots;
    public boolean scores;
    public boolean grid;
    public boolean trace;
    private int traceIdx;
    private boolean traceFirst;
    public double xmax;
    public double xmin;
    public double xscl;
    public double xscl2;
    public double xavg;
    public double xfact;
    public double ymax;
    public double ymin;
    public double yscl;
    public double yscl2;
    public double yavg;
    public double yfact;
    public double xzoom;
    public double yzoom;
    public int xpixels;
    public int ypixels;
    private PostfixList pfl;
    private float mx;
    private float my;
    public int dragstartX;
    public int dragstartY;
    public int dragdX;
    public int dragdY;
    private int curX1;
    private int curX2;
    private int curY1;
    private int curY2;
    int preferredWidth;
    int preferredHeight;

    Graph(GCalc gCalc, int n, int n2) {
        this(gCalc, n, n2, -10.0, 10.0, 1.0, -10.0, 10.0, 1.0);
    }

    Graph(GCalc gCalc, int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        this.host = gCalc;
        this.xpixels = n;
        this.ypixels = n2;
        this.setSize(this.xpixels + 1, this.ypixels + 1);
        this.changeRange(d, d2, d3, d4, d5, d6);
        this.initDefault();
        this.clearList();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void initDefault() {
        this.axis = true;
        this.dots = false;
        this.scores = true;
        this.grid = false;
        this.trace = false;
        this.xzoom = 2.0;
        this.yzoom = 2.0;
        this.my = 0.0f;
        this.mx = 0.0f;
        this.dragstartX = -1;
        this.dragstartY = -1;
        this.dragdX = 0;
        this.dragdY = 0;
        this.traceIdx = 0;
    }

    public void traceMode() {
        this.traceFirst = true;
        this.curX1 = -10;
        this.curY1 = -10;
        this.curX2 = -10;
        this.curY2 = -10;
    }

    private void changeTraceIndex() {
        if (this.pfl.List.size() == 0) {
            return;
        }
        int n = 2;
        do {
            this.traceIdx = (this.traceIdx + 1) % this.pfl.List.size();
            if (this.traceIdx != 0) continue;
            --n;
        } while (this.pfl.getNodeAt(this.traceIdx) == null && n != 0);
        if (n == 0) {
            this.traceIdx = -1;
        }
    }

    private void drawTrace() {
        double d = (double)this.curX1 / this.xfact + this.xmin;
        double d2 = Double.NaN;
        this.page.setXORMode(Color.white);
        this.page.setColor(Color.orange);
        this.page.drawLine(this.curX2, 0, this.curX2, this.ypixels);
        this.page.drawLine(0, this.curY2, this.xpixels, this.curY2);
        this.page.fillRect(this.curX2 - 3, this.curY2 - 3, 7, 7);
        this.page.drawLine(this.curX1, 0, this.curX1, this.ypixels);
        this.traceFirst = false;
        try {
            PostfixListNode postfixListNode = this.pfl.getNodeAt(this.traceIdx);
            if (postfixListNode != null) {
                d2 = postfixListNode.pf.evaluate(d);
            }
            this.curY1 = (int)((d2 - this.ymax) * this.yfact + 0.5);
            this.page.drawLine(0, this.curY1, this.xpixels, this.curY1);
            this.page.fillRect(this.curX1 - 3, this.curY1 - 3, 7, 7);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.dragdY = -10;
        }
        this.referencePt((float)d, (float)d2);
        this.curY2 = this.curY1;
        this.curX2 = this.curX1;
        this.page.setPaintMode();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.trace) {
            this.changeTraceIndex();
        } else {
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    break;
                }
                default: {
                    double d = (double)mouseEvent.getX() / this.xfact + this.xmin;
                    double d2 = (double)mouseEvent.getY() / this.yfact + this.ymax;
                    this.changeRange(d - (this.xmax - this.xmin) / 2.0, d + (this.xmax - this.xmin) / 2.0, this.xscl, d2 - (this.ymax - this.ymin) / 2.0, d2 + (this.ymax - this.ymin) / 2.0, this.yscl);
                    this.host.updateRangeTF();
                    this.clearGraph();
                    this.drawPostfix();
                }
            }
        }
        this.mouseMoved(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.page != null) {
            if (this.trace) {
                if (this.curX2 != -10 && this.curY2 != -10 && this.curX1 != -10 && this.curY1 != -10) {
                    this.drawTrace();
                }
                this.curX1 = mouseEvent.getX();
                this.mx = (float)((double)mouseEvent.getX() / this.xfact + this.xmin);
                this.drawTrace();
                this.page.setPaintMode();
                this.drawCoordinate();
            } else {
                this.page.setPaintMode();
                this.referencePt((float)((double)mouseEvent.getX() / this.xfact + this.xmin), (float)((double)mouseEvent.getY() / this.yfact + this.ymax));
                this.drawCoordinate();
            }
        }
        this.repaint();
    }

    public void referencePt(float f, float f2) {
        this.mx = f;
        this.my = f2;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.trace) {
            return;
        }
        if (this.dragstartX == -1 && this.dragstartY == -1) {
            this.dragstartX = mouseEvent.getX();
            this.dragstartY = mouseEvent.getY();
            this.dragdX = 0;
            this.dragdY = 0;
        } else {
            this.page.setXORMode(Color.white);
            this.page.setColor(Color.orange);
            this.page.drawRect(this.dragstartX - this.dragdX, this.dragstartY - this.dragdY, 2 * this.dragdX, 2 * this.dragdY);
            this.dragdX = Math.abs(mouseEvent.getX() - this.dragstartX);
            this.dragdY = Math.abs(mouseEvent.getY() - this.dragstartY);
            this.page.drawRect(this.dragstartX - this.dragdX, this.dragstartY - this.dragdY, 2 * this.dragdX, 2 * this.dragdY);
            this.mouseMoved(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.trace) {
            return;
        }
        this.page.setPaintMode();
        if (this.dragstartX != -1 && this.dragstartY != -1) {
            this.host.graphFitZoomButton.setLabel("Box Zoom");
        } else {
            this.host.graphFitZoomButton.setLabel("Graph-Fit Zoom");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.trace) {
            return;
        }
        if (this.dragstartX != -1 && this.dragstartY != -1) {
            this.page.setXORMode(Color.white);
            this.page.setColor(Color.orange);
            this.page.drawRect(this.dragstartX - this.dragdX, this.dragstartY - this.dragdY, 2 * this.dragdX, 2 * this.dragdY);
            this.dragstartX = mouseEvent.getX();
            this.dragstartY = mouseEvent.getY();
            this.dragdX = 0;
            this.dragdY = 0;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.trace) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.trace) {
            this.mx = Float.NaN;
            this.my = Float.NaN;
        }
        this.drawCoordinate();
    }

    private void drawCoordinate() {
        this.page.setColor(Color.gray);
        this.page.fillRect(3, 2, 120, 23);
        this.page.setColor(Color.lightGray);
        this.page.fillRect(0, 0, 120, 23);
        this.page.setColor(Color.black);
        this.page.drawString("x = " + Graph.nonNaNString(this.mx), 5, 10);
        this.page.drawString("y = " + Graph.nonNaNString(this.my), 5, 20);
        this.repaint();
    }

    private static String nonNaNString(float f) {
        if (Float.isNaN(f)) {
            return "";
        }
        return "" + f;
    }

    public void changeRange(double d, double d2, double d3, double d4, double d5, double d6) {
        if (!(!(d2 > d) || !(d5 > d4) || this.isNotReal(d) || this.isNotReal(d2) || this.isNotReal(d3) || this.isNotReal(d4) || this.isNotReal(d5) || this.isNotReal(d6))) {
            this.xscl = Math.abs(d3);
            this.yscl = Math.abs(d6);
            this.xmax = d2;
            this.xmin = d;
            this.ymax = d5;
            this.ymin = d4;
        }
        this.xavg = (this.xmax + this.xmin) / 2.0;
        this.xfact = (double)this.xpixels / (this.xmax - this.xmin);
        this.yavg = (this.ymax + this.ymin) / 2.0;
        this.yfact = (double)this.ypixels / (this.ymin - this.ymax);
        if (this.image != null) {
            this.clearGraph();
        }
    }

    public void fitToZoomBox() {
        double d = (double)(this.dragstartX - this.dragdX) / this.xfact + this.xmin;
        double d2 = (double)(this.dragstartX + this.dragdX) / this.xfact + this.xmin;
        double d3 = (double)(this.dragstartY - this.dragdY) / this.yfact + this.ymax;
        double d4 = (double)(this.dragstartY + this.dragdY) / this.yfact + this.ymax;
        this.changeRange(d, d2, this.xscl, d4, d3, this.yscl);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (this.image == null) {
            this.image = this.createImage(this.xpixels + 1, this.ypixels + 1);
            this.page = this.image.getGraphics();
            this.clearGraph();
        }
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void clearList() {
        this.pfl = new PostfixList();
    }

    public void clearGraph() {
        if (this.image == null) {
            return;
        }
        this.traceMode();
        this.page.setColor(Color.white);
        this.page.fillRect(0, 0, this.xpixels + 1, this.ypixels + 1);
        if (this.grid) {
            this.drawGrid();
        }
        if (this.axis) {
            this.drawAxis();
        }
        if (this.scores) {
            this.drawScores();
        }
        this.pfl.deflagAll();
        this.referencePt(Float.NaN, Float.NaN);
        this.drawCoordinate();
        this.dragstartX = -1;
        this.dragstartY = -1;
        this.dragdX = 0;
        this.dragdY = 0;
        this.host.graphFitZoomButton.setLabel("Graph-Fit Zoom");
    }

    private void drawAxis() {
        int n = (int)(-this.xmin * this.xfact + 0.5);
        int n2 = (int)(-this.ymax * this.yfact + 0.5);
        this.page.setColor(Color.red);
        if (this.YonScreen(n2)) {
            this.page.drawLine(0, n2, this.xpixels - 1, n2);
        }
        if (this.XonScreen(n)) {
            this.page.drawLine(n, 0, n, this.ypixels - 1);
        }
    }

    private void saveScl() {
        this.xscl2 = this.xscl;
        this.yscl2 = this.yscl;
        if (this.xscl != 0.0 && 1.0 / this.xscl > Math.abs(3.0 * this.xfact)) {
            this.xscl = Math.abs(1.0 / this.xfact);
        }
        if (this.yscl != 0.0 && 1.0 / this.yscl > Math.abs(3.0 * this.yfact)) {
            this.yscl = Math.abs(1.0 / this.yfact);
        }
    }

    private void restoreScl() {
        this.xscl = this.xscl2;
        this.yscl = this.yscl2;
    }

    private void drawGrid() {
        int n;
        int n2;
        double d;
        int n3 = (int)(-this.xmin * this.xfact + 0.5);
        int n4 = (int)(-this.ymax * this.yfact + 0.5);
        this.saveScl();
        this.page.setColor(Color.lightGray);
        if (this.xscl != 0.0) {
            d = this.xscl * (double)((int)(this.xmin / this.xscl + 0.5));
            while (d <= this.xmax) {
                n2 = (int)((d - this.xmin) * this.xfact + 0.5);
                n = (int)((-d - this.xmin) * this.xfact + 0.5);
                this.page.drawLine(n2, 0, n2, this.ypixels - 1);
                this.page.drawLine(n, 0, n, this.ypixels - 1);
                d += this.xscl;
            }
        }
        if (this.yscl != 0.0) {
            d = this.yscl * (double)((int)(this.ymin / this.yscl + 0.5));
            while (d <= this.ymax) {
                n2 = (int)((d - this.ymax) * this.yfact + 0.5);
                n = (int)((-d - this.ymax) * this.yfact + 0.5);
                this.page.drawLine(0, n2, this.xpixels - 1, n2);
                this.page.drawLine(0, n, this.xpixels - 1, n);
                d += this.yscl;
            }
        }
        this.restoreScl();
    }

    private void drawScores() {
        int n;
        int n2;
        double d;
        int n3 = (int)(-this.xmin * this.xfact + 0.5);
        int n4 = (int)(-this.ymax * this.yfact + 0.5);
        this.saveScl();
        this.page.setColor(Color.blue);
        if (this.YonScreen(n4) && this.xscl != 0.0) {
            d = this.xscl * (double)((int)(this.xmin / this.xscl + 0.5));
            while (d <= this.xmax) {
                n2 = (int)((d - this.xmin) * this.xfact + 0.5);
                n = (int)((-d - this.xmin) * this.xfact + 0.5);
                this.page.drawLine(n2, n4 - 1, n2, n4 + 1);
                this.page.drawLine(n, n4 - 1, n, n4 + 1);
                d += this.xscl;
            }
        }
        if (this.XonScreen(n3) && this.yscl != 0.0) {
            d = this.yscl * (double)((int)(this.ymin / this.yscl + 0.5));
            while (d <= this.ymax) {
                n2 = (int)((d - this.ymax) * this.yfact + 0.5);
                n = (int)((-d - this.ymax) * this.yfact + 0.5);
                this.page.drawLine(n3 - 1, n2, n3 + 1, n2);
                this.page.drawLine(n3 - 1, n, n3 + 1, n);
                d += this.yscl;
            }
        }
        this.restoreScl();
    }

    private boolean YoutOfBounds(double d) {
        if (Double.isInfinite(d)) {
            return true;
        }
        if (Double.isNaN(d)) {
            return true;
        }
        if (d < this.ymin) {
            return true;
        }
        return d > this.ymax;
    }

    private boolean XoutOfBounds(double d) {
        if (Double.isInfinite(d)) {
            return true;
        }
        if (Double.isNaN(d)) {
            return true;
        }
        if (d < this.xmin) {
            return true;
        }
        return d > this.xmax;
    }

    private boolean YonScreen(double d) {
        return d >= 0.0 && d < (double)this.ypixels;
    }

    private boolean XonScreen(double d) {
        return d >= 0.0 && d < (double)this.xpixels;
    }

    boolean isNotReal(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    public void drawPostfix() {
        int n = 0;
        while (n < this.pfl.List.size()) {
            PostfixListNode postfixListNode = this.pfl.getNodeAt(n);
            if (!postfixListNode.drawn) {
                this.drawGraph(postfixListNode.pf, postfixListNode.color);
                postfixListNode.drawn = true;
            }
            ++n;
        }
    }

    public void drawPostfix(Postfix postfix, Color color) {
        if (postfix == null) {
            return;
        }
        if (!postfix.getStack().isEmpty()) {
            this.pfl.add(postfix, color);
        }
        this.drawPostfix();
        this.repaint();
    }

    private void drawGraph(Postfix postfix, Color color) {
        if (postfix == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = -50;
        int n4 = 50;
        double d = Double.NaN;
        double d2 = 0.0;
        this.page.setColor(color);
        double d3 = 0.0;
        while (d3 <= (double)this.xpixels) {
            d2 = postfix.evaluate(d3 / this.xfact + this.xmin);
            n = (int)d3;
            n2 = (int)((d2 - this.ymax) * this.yfact + 0.5);
            if (!(this.YoutOfBounds(d2) && this.YoutOfBounds(d) || this.isNotReal(d2))) {
                if (this.dots || this.isNotReal(d)) {
                    this.page.drawLine(n, n2, n, n2);
                } else {
                    this.page.drawLine(n, n2, n3, n4);
                }
            }
            d = d2;
            n3 = n;
            n4 = n2;
            d3 += 1.0;
        }
    }

    public PostfixList getList() {
        return this.pfl;
    }

    public void remove(int n) {
        this.pfl.remove(n);
    }
}

