/* Copyright (C) 1999 Denis Chertykov <denisc@overta.ru>

This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
author gives you unlimited permission to link the
compiled version of this file into combinations with other programs,
and to distribute those combinations without any restriction coming
from the use of this file.  (The General Public License restrictions
do apply in other respects; for example, they cover modification of
the file, and distribution when not linked into a combine
executable.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.  */

/* Hacked a lot by Marek Michalkiewicz <marekm@linux.org.pl> to add
   support for many MCU types, etc.  These changes are public domain.  */

;; -*- mode: asm -*-

#include "macros.inc"

#if !defined (__AVR_ASM_ONLY__)
; not required by gas, but still a nice way to show referenced symbols
	.extern _U(main)
	.extern _etext
	.extern __data_start
	.extern _edata
	.extern __bss_start
	.extern __bss_end

; Stack init in main() (can override with avr-ld --defsym __stack=...)
;	.weak __stack
;__stack = RAMEND
	.extern __stack

; These too can be set with the avr-ld --defsym name=value option
; (MCUCR must be set up correctly to enable external SRAM).
	.weak	__init_mcucr__
	.weak	__init_emcucr__
	.weak	__init_wdtcr__

; You can plug in your own code to handle unexpected
; interrupts (which usually indicate a bug - if the program
; enables an interrupt for which there is no handler).
	.weak	_U(_unexpected_)
#endif /* if !defined (__AVR_ASM_ONLY__) */

; You can plug in your own asm code that runs immediately
; after reset, without any initialization at all.  When done,
; it should jump to _real_init_.
	.weak	_U(_init_)
;
; Vector table macros
;
	.set	no_vect, 0
	.macro	VEC name
	  .if		(END_VECTOR > no_vect)
	    .weak	_U(\name)
	    #if !defined (__AVR_ASM_ONLY__)
	    .set	_U(\name), _unexpected_1_
	    #endif
	    XJMP	_U(\name)
	  .endif
	  .set 		no_vect, no_vect + 1
	.endm

; reset and interrupt vectors, starting at absolute address 0

	.section .init, "ax", @progbits
	.func	.__start_of_init__
.__start_of_init__:
	XJMP	_U(_init_)

	VEC	_vector_1
	VEC	_vector_2
	VEC	_vector_3
	VEC	_vector_4
	VEC	_vector_5
	VEC	_vector_6
	VEC	_vector_7
	VEC	_vector_8
	VEC	_vector_9
	VEC	_vector_10
	VEC	_vector_11
	VEC	_vector_12
	VEC	_vector_13
	VEC	_vector_14
	VEC	_vector_15
	VEC	_vector_16
	VEC	_vector_17
	VEC	_vector_18
	VEC	_vector_19
	VEC	_vector_20
	VEC	_vector_21
	VEC	_vector_22
	VEC	_vector_23
	VEC	_vector_24
	VEC	_vector_25
	VEC	_vector_26
	VEC	_vector_27
	VEC	_vector_28
	VEC	_vector_29
	VEC	_vector_30
	VEC	_vector_31
	VEC	_vector_32
	VEC	_vector_33
	VEC	_vector_34
	VEC	_vector_35
	VEC	_vector_36
	VEC	_vector_37
	VEC	_vector_38
	VEC	_vector_39

	/* extra check */
;	.if . - .__start_of_init__ - INT_VECT_SIZE
;	.err
;	.endif

	.endfunc

#if !defined (__AVR_ASM_ONLY__)
	.section .text, "ax", @progbits
	.func	.__c_startup__
.__c_startup__:
; two remporary registers (usable with ldi, not pointer registers)
#define r_tmp1 r18
#define r_tmp2 r19

/*
 * I/O instructions below (out) require an address < 0x40.
 * If an SFR offset is being used, the register address needs to be
 * scaled back from its DATA memory address to its I/O memory address.
 */
#ifndef __SFR_OFFSET
#define __SFR_OFFSET 0
#endif /* !__SFR_OFFSET */

	.global _U(_real_init_)
_U(_real_init_):
_U(_init_):
	clr	__zero_reg__
	out	(SREG - __SFR_OFFSET), __zero_reg__
#ifdef WDTCR
	ldi	r_tmp1, lo8(__init_wdtcr__)
	wdr
	out	(WDTCR - __SFR_OFFSET), r_tmp1
#endif
#ifdef MCUCR
	ldi	r_tmp1, lo8(__init_mcucr__)
	out	(MCUCR - __SFR_OFFSET), r_tmp1
#endif
#ifdef EMCUCR
	ldi	r_tmp1, lo8(__init_emcucr__)
	out	(EMCUCR - __SFR_OFFSET), r_tmp1
#endif
; XXX should we also read, save and clear MCUSR (if present) here?
; (datasheets suggest to do it as soon as possible after reset)
	ldi	ZL, lo8(_etext); load the end of .text segment
	ldi	ZH, hi8(_etext); this is a start of .data image
#if BIG_CODE
	ldi	r_tmp2, hh8(_etext)	; this will be in RAMPZ for "elpm"
#endif
	ldi	XL, lo8(__data_start)	; load start of ram
	ldi	XH, hi8(__data_start)
#if XRAMEND > 0x100  /* don't bother with high byte if we know it must be 0 */
	ldi	r_tmp1, hi8(_edata)
#endif
	LPM_R0_ZPLUS_INIT r_tmp2
	rjmp	.copy_data_start
.copy_data_loop:
	LPM_R0_ZPLUS_NEXT r_tmp2
	st	X+, r0
.copy_data_start:
	cpi	XL, lo8(_edata)
#if XRAMEND > 0x100
	cpc	XH, r_tmp1	; hi8(_edata)
#endif
	brne	.copy_data_loop
	;; avr-ld always put .bss after .data
	; If the above is true, then no need to load X again below.
	; But there are two separate symbols _edata and __bss_start
	; which seem to have the same value but are initialized
	; in two different places in the linker script.
#if 1
	ldi	XL, lo8(__bss_start)
	ldi	XH, hi8(__bss_start)
#endif
#if XRAMEND > 0x100
	ldi	r_tmp1, hi8(__bss_end)
#endif
	rjmp	.zero_bss_start
.zero_bss_loop:
	st	X+, __zero_reg__
.zero_bss_start:
	cpi	XL, lo8(__bss_end)
#if XRAMEND > 0x100
	cpc	XH, r_tmp1	; hi8(__bss_end)
#endif
	brne	.zero_bss_loop
	XJMP	_U(main)

_unexpected_1_:
	XJMP	_U(_unexpected_)

_U(_unexpected_):
	reti

	.endfunc
#endif /* if !defined (__AVR_ASM_ONLY__) */
