#ifndef _TIMER_H_
#define _TIMER_H_

#include <io.h>

#ifdef __cplusplus
extern "C" {
#endif

enum {
  STOP             = 0,
  CK               = 1,
  CK8              = 2,
  CK64             = 3,
  CK256            = 4,
  CK1024           = 5,
  T0_FALLING_EDGE  = 6,
  T0_RISING_EDGE   = 7
};

static inline void timer0_source (unsigned int src)
{
  outb (src, TCCR0);
}

static inline void timer0_stop (void)
{
  outb (0, TCNT0);
}

static inline void timer0_start (void)
{
  outb (0x1, TCNT0);
}

#ifdef __cplusplus
}
#endif

#endif /* _TIMER_H_ */
