//
// EVAL.H: Mathematischer Evaluierer           (c) in 1997 by FUTUREWARE 2001
//

#ifndef __EVAL
#define __EVAL
#define TYP S4
#define RESERVE 18
#define MREGISTER 256
// ()[]Z*/%+-:=<>&|

U1 Analyse[50][2],Schachtel;
TYP Zahlen[MREGISTER];
void Tiefe()
{
  U1 i;
  Schachtel=0;
  for (i=0;i<strlen((S1*)Analyse[0]);i++)
    Schachtel=max(Schachtel,Analyse[i][1]);
}

TYP Evaluate(char *Term, int Size, TYP Array[])
{
  S1 Weiter,Stufe,Extra=0;
  S2 R=0,W=0;
  U2 Zahl=RESERVE;
  TYP Z=0;
  if(!strlen(Term)) return 0;
  memset(Analyse,0,sizeof(Analyse));
  Schachtel=1;
  #ifdef DEBUG
    printf("Evaluiere: %s -> ",Term);
  #endif
  Extra=0;
  for (R=0;R<Size;R++)
  {
    switch(Term[R])
    {
      #define U Analyse[W-1][1]=++Schachtel;
      #define D Analyse[W-1][1]=Schachtel--;Schachtel-=Extra;Extra=0;if(Schachtel<1) Fehler("Klammerfehler: %s\n",Term);
      #define S Analyse[W-1][1]=Schachtel;
      case ' ': break;
      case '(': Analyse[W++][0]=1 ;U;break;//Klammern
      case ')': Analyse[W++][0]=2 ;D;break;//Klammern
      case '[': Analyse[W++][0]=3 ;U;break;//Speicher
      case ']': Analyse[W++][0]=4 ;D;break;//Speicher
      case 'Z': Analyse[W++][0]=5 ;S;break;//Zufall A Z B = A<=Z<=B
      case '*': Analyse[W++][0]=6 ;S;break;//Multiplikation
      case '/': Analyse[W++][0]=7 ;S;break;//Division
      case '%': Analyse[W++][0]=8 ;S;break;//Rest
      case '+': Analyse[W++][0]=9 ;S;break;//Addition
      case '-': Analyse[W++][0]=10;S;break;//Subtraktion
      case '=': Analyse[W++][0]=11;S;break;//Vergleich A=B ?
      case '<': Analyse[W++][0]=12;S;break;//Vergleich A<B ?
      case '>': Analyse[W++][0]=13;S;break;//Vergleich A>B ?
      case '&': Analyse[W++][0]=14;S;break;//Vergleich A?B & C?D ?
      case '|': Analyse[W++][0]=15;S;break;//Vergleich A?B | C?D ?
      case '!': Analyse[W++][0]=16;S;break;//Not !A
      case ':': Analyse[W++][0]=17;U;Extra=1;break;//Zuweisung
      case '0': case'1':case'2':case'3':case'4':case'5':case'6':case'7':case'8':case'9':
      {
        Analyse[W++][0]=Zahl++;S;
        Z=Term[R]-'0';
        while ((Term[R+1]>='0') && (Term[R+1]<='9'))
        {
          Z*=10;
          Z+=Term[R+1]-'0';
          R++;
        }
        Zahlen[Zahl-RESERVE-1]=Z;
        break;
      }
      #undef U
      #undef D
      #undef S
    }
  }
  Tiefe();
  #define _MM(x) memmove((S1*)&Analyse[R+1][0],(S1*)&Analyse[R+1+(x)][0],strlen((S1*)Analyse)-2*(R-(x)+1));Weiter=0;Stufe=0;
  while (Analyse[1][0]!=0)
  {
    Weiter=1;Stufe=1;

    for(R=0;(int)R+2<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    if(Analyse[R][0]==1 && Analyse[R+1][0]>=RESERVE && Analyse[R+2][0]==2)
    { // ( Z ) Klammern
      Analyse[R][0]=Analyse[R+1][0];Analyse[R][1]--;_MM(2);Tiefe();
    };

    if(Weiter) for(R=0;R+2<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    if(Analyse[R][0]==3 && Analyse[R+1][0]>=RESERVE && Analyse[R+2][0]==4 && Analyse[R+3][0]!=17)
    { // [ Z ] Speicheroperation
      Zahlen[Analyse[R+1][0]-RESERVE]=Array[minmax(0,Zahlen[Analyse[R+1][0]-RESERVE],MREGISTER-1)];
      Analyse[R][0]=Analyse[R+1][0];Analyse[R][1]--;_MM(2);Tiefe();
    };

    if(Weiter) for(R=0;R+2<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    if(Analyse[R][0]>=RESERVE && Analyse[R+1][0]==5 && Analyse[R+2][0]>=RESERVE)
    { // A Z B ZUFALL
      Zahlen[Analyse[R][0]-RESERVE]=rnd(Zahlen[Analyse[R][0]-RESERVE],Zahlen[Analyse[R+2][0]-RESERVE]);_MM(2);
    }

    if(Weiter) for(R=0;R+2<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    {
      if (Analyse[R][1]==Schachtel &&Analyse[R][0]>=RESERVE && Analyse[R+1][0]==7 && Analyse[R+2][0]>=RESERVE)
      { // Z / Z Division
        Zahlen[Analyse[R][0]-RESERVE]/=Zahlen[Analyse[R+2][0]-RESERVE];_MM(2);
      };
      if (Analyse[R][1]==Schachtel &&Analyse[R][0]>=RESERVE && Analyse[R+1][0]==8 && Analyse[R+2][0]>=RESERVE)
      { // Z % Z Division
        Zahlen[Analyse[R][0]-RESERVE]%=Zahlen[Analyse[R+2][0]-RESERVE];_MM(2);
      };
      if (Analyse[R][1]==Schachtel &&Analyse[R][0]>=RESERVE && Analyse[R+1][0]==6 && Analyse[R+2][0]>=RESERVE)
      { // Z * Z Multiplikation
        Zahlen[Analyse[R][0]-RESERVE]*=Zahlen[Analyse[R+2][0]-RESERVE];_MM(2);
      };
    }

    if(Weiter) for(R=0;R+2<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    {
      if (Analyse[R][1]==Schachtel && Analyse[R][0]>=RESERVE && Analyse[R+1][0]==10 && Analyse[R+2][0]>=RESERVE)
      { // Z - Z Subtraktion
        Zahlen[Analyse[R][0]-RESERVE]-=Zahlen[Analyse[R+2][0]-RESERVE];_MM(2);
      };
      if (Analyse[R][1]==Schachtel && Analyse[R][0]>=RESERVE && Analyse[R+1][0]==9 && Analyse[R+2][0]>=RESERVE)
      { // Z + Z Addition
        Zahlen[Analyse[R][0]-RESERVE]+=Zahlen[Analyse[R+2][0]-RESERVE];_MM(2);
      };
    }

    if(Weiter) for(R=0;R+2<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    {
      if (Analyse[R][1]==Schachtel && Analyse[R][0]>=RESERVE && Analyse[R+1][0]==11 && Analyse[R+2][0]>=RESERVE)
      { // Z = Z Vergleich  
        Zahlen[Analyse[R][0]-RESERVE]=(Zahlen[Analyse[R][0]-RESERVE]==Zahlen[Analyse[R+2][0]-RESERVE]);_MM(2);
      };
      if (Analyse[R][1]==Schachtel && Analyse[R][0]>=RESERVE && Analyse[R+1][0]==12 && Analyse[R+2][0]>=RESERVE)
      { // Z < Z Vergleich  
        Zahlen[Analyse[R][0]-RESERVE]=(Zahlen[Analyse[R][0]-RESERVE]<Zahlen[Analyse[R+2][0]-RESERVE]);_MM(2);
      };
      if (Analyse[R][1]==Schachtel && Analyse[R][0]>=RESERVE && Analyse[R+1][0]==13 && Analyse[R+2][0]>=RESERVE)
      { // Z > Z Vergleich  
        Zahlen[Analyse[R][0]-RESERVE]=(Zahlen[Analyse[R][0]-RESERVE]>Zahlen[Analyse[R+2][0]-RESERVE]);_MM(2);
      };
    }

    if(Weiter) for(R=0;R+2<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    {
      if (Analyse[R][1]==Schachtel && Analyse[R][0]>=RESERVE && Analyse[R+1][0]==14 && Analyse[R+2][0]>=RESERVE)
      { // Z & Z Vergleich  
        Zahlen[Analyse[R][0]-RESERVE]=(Zahlen[Analyse[R][0]-RESERVE] && Zahlen[Analyse[R+2][0]-RESERVE]);_MM(2);
      };
      if (Analyse[R][1]==Schachtel && Analyse[R][0]>=RESERVE && Analyse[R+1][0]==15 && Analyse[R+2][0]>=RESERVE)
      { // Z | Z Vergleich  
        Zahlen[Analyse[R][0]-RESERVE]=(Zahlen[Analyse[R][0]-RESERVE] || Zahlen[Analyse[R+2][0]-RESERVE]);_MM(2);
      };
    }

    if(Weiter) for(R=0;R+1<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    if(Analyse[R][1]==Schachtel && Analyse[R][0]==16 && Analyse[R+1][0]>=RESERVE)
    { // !Z NOT
      Zahlen[Analyse[R+1][0]-RESERVE]=!Zahlen[Analyse[R+1][0]-RESERVE];Analyse[R][0]=Analyse[R+1][0];_MM(1);
    }

    if(Weiter) for(R=0;R+1<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    if (Analyse[R][1]==Schachtel && Analyse[R][0]==10 && Analyse[R+1][0]>=RESERVE)
    { // -Z Negative Zahlen
      Zahlen[Analyse[R+1][0]-RESERVE]=-Zahlen[Analyse[R+1][0]-RESERVE];Analyse[R][0]=Analyse[R+1][0];_MM(1);
    };

    if(Weiter) for(R=0;R+4<(S2)(strlen((S1 *)Analyse)>>1);R+=Stufe,Stufe=1)
    if(Analyse[R][0]==3 && Analyse[R+1][0]>=RESERVE && Analyse[R+2][0]==4&& Analyse[R+3][0]==17&& Analyse[R+4][0]>RESERVE)
    { // [Z]:Z Speicherzuweisung
      Analyse[R][0]=Analyse[R+4][0];
      Array[minmax(0,Zahlen[Analyse[R+1][0]-RESERVE],MREGISTER-1)]=Zahlen[Analyse[R+4][0]-RESERVE];
      Analyse[R][1]--;
      _MM(4);Tiefe();
    }
    if(Weiter) Fehler("Fehler in Ausdruck: %s\n",Term);
  }
  #ifdef DEBUG
    printf("%d\n",Zahlen[Analyse[0][0]-RESERVE]);
  #endif
  return (Zahlen[Analyse[0][0]-RESERVE]);
}

TYP Eval(char *Term, TYP Array[])
{
  return(Evaluate(Term,strlen(Term),Array));
}

#endif
