
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#include "Gd_monomer.h" 
#include "Gd_polymer.h" 
#include "Gd_noise.h" 
#include "Gd_properties.h" 
 
 
 
/********************************************************************\  
*         GdProperties        M E M B E R S  
\********************************************************************/  
double GdProperties::kineticEnergy(GdMonomer &m){  
  double vx, vy, vz;  
  m.getVelocity(vx, vy, vz);  
   
  double tmp;  
  tmp = vx * vx + vy * vy + vz * vz;  
  tmp *= 0.50;  
  return tmp;  
};  
 
 
 
double GdProperties::temperature(GdMonomer &m){  
  static double factor = 1.0/3.0;  
  double vx, vy, vz;  
  double tmp;  
  m.getVelocity(vx, vy, vz);  
  tmp = vx * vx + vy * vy + vz * vz;  
  tmp *= factor;  
  return tmp;  
};  
 
 
 
 
 
 
 
double GdProperties::temperature(GdPolymer &data){  
  static double factor = 1.0/3.0;  
  int N = data.getSize();  
  double tmp = 0.0;  
   
  for (int i = 0; i < N; i++){  
    double vx, vy, vz;  
    data[i].getVelocity(vx, vy, vz);  
    tmp += vx * vx + vy * vy + vz * vz;  
  };  
   
  tmp *= factor / N;  
  return tmp;  
};  
 
 
double GdProperties::kineticEnergy(GdPolymer &data){  
  double tmp = 0.0;  
  for(int i = 0; i < data.getSize(); i++){  
    double vx, vy, vz;  
    data[i].getVelocity(vx, vy, vz);  
    tmp += vx * vx + vy * vy + vz * vz;  
  };  
  tmp *= 0.50;  
  return tmp;  
};  
 
