# $Id: gdcalc.spec,v 1.11 2002/06/19 12:37:11 bhepple Exp $
# make rpm with: 
# cd ~/fun/dcalc/gtk/src
# make && make install
# cd ..
# root rpm -bb gdcalc.spec
#
# Manual method to make dist
# cd ~/fun/dcalc
# mkdir gdcalc-x.x
# cp -rp gtk/* gdcalc-x.x
# root chown -R root gdcalc-x.x
# ... clean it up eg. remove CVS directories, make distclean
# tar czhf gdcalc-2.11.tgz gdcalc-2.11 
# root chown -R root dcalc-x.x
#
# Auto method to make dist: this is really confusing.
# glade->build (make sure gettext is disabled in C Options)
# ./autogen.sh (will fail on automake - remove gettext)
# add AC_PROG_YACC to configure.in; remove intl & po; edit version #
# remove gnome-gettext.m4 from macros/Makefile.am
# automake
# enter version number in configure.in (and here!)
# autoconf
# ./configure
# make dist    !!!
# cp gdcalc-%{ver}.tar.gz /usr/src/redhat/SOURCES
# (root) rpm -ba gdcalc.spec
# 

%define ver 2.13
%define rel 1
%define prefix /usr

Summary: gdcalc - a financial, statistics, scientific and programmers calculator for GTK+
Name: gdcalc
Version: %{ver}
Release: %{rel}
Copyright: GPL
Group: Applications/Productivity
Source: http://bhepple.freeshell.org/unix/gdcalc-%{ver}.tar.gz
Packager: Bob Hepple <bhepple@freeshell.org>
Buildroot: /var/tmp/%{name}-root
requires: units
%description

gdcalc is a financial, statistics, scientific and programmers
calculator for gtk+-based under Unix and Linux.

It has both Algebraic notation (ie. conventional, TI or Casio-like)
and Reverse Polish Notation (HP-style).

I have also included some nice conversions based on units(1) including
length (miles, km, mm etc), area, (hectares, acres, sq ft etc), volume
(litres, US & UK gallons etc) mass, pressure, fuel consumption (mpg,
litres/100km), temperature, currency ... and anything else that
units(1) can cope with. Metric, US and British units are supported -
e.g. a US gallon is a measly 3.78 litres as opposed to the much more
generous British gallon at 4.54 litres.

It is fully programmable (you've got the source, ninny) and I've left
loads of blank keys on the GUI for you to add in your favourites. If
you add functions that you think would be interesting for the world at
large, please let me have the diffs and I'll put them in.

To get better fonts for the numbers and buttons, copy the file
/usr/local/etc/gdcalc.rc to .gdcalc.rc in your home directory and
customise.

gdcalc is based on my venerable dcalc RPN calculator which I wrote
about a million years ago to learn C and curses - about 1983, I
suppose.

The original dcalc for curses (Unix console) is at
http://bhepple.freeshell.org/unix/dcalcCurses.html

There is another version of this for the Psion (RPN only) at:
http://sedumi.freeshell.org/psion

This is about as much of a manual that I feel like writing - if you
want to know more about RPN calculators (and why they are more
intuitive than algebraic calculators with their = sign) take a
look at http://www.hpcalc.org

Have fun with it! Bob Hepple: mailto:bhepple@freeshell.org

%prep
rm -rf $RPM_BUILD_ROOT

%setup
%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}
make

%install
make prefix=${RPM_BUILD_ROOT}%{prefix} install

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc README COPYING manual_en.html gdcalc.rc
%{prefix}
