#include "colors.inc"
#include "textures.inc"
#include "glass.inc"

// Author: Antonio Castro

// The camera will look towards the contact point
// of both spheres

camera {
  location <0, 15, 35>
  look_at <0, 10, 0>
}

// Source of white light
object {
  light_source {
  <20, 100, 50>
  color White
  }
}

// Sky with white clouds
object {
 sphere { <0, 0, 0> 200000}  // Great vault of heaven
// We strecht the clouds
 texture {pigment {Blue_Sky} scale <50000, 6000, 50000>}
}

// Golden ball
sphere { <-10, 10, 0> 10
    texture { Gold_Metal }
}

// Mirror ball
sphere { <10, 10, 0> 10
    texture { finish { Mirror} }
}

// Glass ball
sphere { <0, 5, 10> 5
    texture { T_Glass1 }
}

// Floor
// It is made with a great sphere that touches the center <0,0,0>
// but it could be implemented with a plane.
sphere {<0, -1000000, 0> 1000000
// Checker texture
 pigment {checker color Red color Yellow scale 2 }
}
