/* vim: set sw=8 ts=8 si : */
/*************************************************************************
 Title	:   C include file for uart
 Target:    any AVR device
 Copyright: GPL
***************************************************************************/
#ifndef UART_H
#define UART_H
#include <avr/pgmspace.h>

/* public result buffer len for uart_outbuf */ 
#define UART_RX_BUFFER_SIZE 23

extern void uart_init(void); /* call this function and then enable interrupt with sei() */
extern void uart_sendchar(char c); /* send one char */
extern void uart_sendstr(char *s); /* send a string */
extern void uart_sendstr_p(const prog_char *progmem_s);
extern void uart_reset(void);
extern unsigned char uart_getrxbufnl(char *uart_outbuf);

/*
* ** macros for automatically storing string constant in program memory
* */
#ifndef P
#define P(s) ({static const char c[] __attribute__ ((progmem)) = s;c;})
#endif
#define uart_sendstr_P(__s)         uart_sendstr_p(P(__s))

#endif /* UART_H */
