/*************************************************************************
 Title	:   C include file for the HW defs of for the HD44780U LCD library
 Author:    Markus Ermert 
***************************************************************************/
#ifndef LCD_HW_H
#define LCD_HW_H


/* change these definitions to adapt setting */



#define LCD_IO_MODE  1    /* 0: memory mapped mode, 1: IO port mode (4 data lines) */

#if LCD_IO_MODE  /* only necessary in IO mode */

#define LCD_DATA_PORT_D7 PORTC	/* arbitrary port for LCD data line D7 */
#define LCD_DATA_PORT_D6 PORTC	/* arbitrary port for LCD data line D6 */
#define LCD_DATA_PORT_D5 PORTC	/* arbitrary port for LCD data line D5 */
#define LCD_DATA_PORT_D4 PORTC	/* arbitrary port for LCD data line D4 */

#define LCD_DATA_PIN_D7  PC3	/* arbitrary pin for LCD data line D7 */
#define LCD_DATA_PIN_D6  PC2	/* arbitrary pin for LCD data line D7 */
#define LCD_DATA_PIN_D5  PC1	/* arbitrary pin for LCD data line D5 */
#define LCD_DATA_PIN_D4  PC0	/* arbitrary pin for LCD data line D4 */

#define LCD_RS_PORT      PORTB  /* port for RS line */
#define LCD_RS_PIN       PB4
#define LCD_RW_PORT      PORTB  /* port for RW line */
#define LCD_RW_PIN       PB5
#define LCD_E_PORT       PORTD  /* port for Enable line */
#define LCD_E_PIN        PD4

#else            /* only necessary in memory mapped mode */
#define LCD_IO_DATA      0xC000    /* A15=E=1, A14=RS=1                 */
#define LCD_IO_FUNCTION  0x8000    /* A15=E=1, A14=RS=0                 */
#define LCD_IO_READ      0x0100    /* A8 =R/W=1 (R/W: 1=Read, 0=Write   */
#endif

/* normally you do not change the following */
#define LCD_LINES           2     /* visible lines */
#define LCD_LINE_LENGTH  0x40     /* internal line length */
#define LCD_START_LINE1  0x00     /* DDRAM address of first char of line 1 */
#define LCD_START_LINE2  0x40     /* DDRAM address of first char of line 2 */
#define LCD_START_LINE3  0x14     /* DDRAM address of first char of line 3 */
#define LCD_START_LINE4  0x54     /* DDRAM address of first char of line 4 */

#endif //LC_HW_H

