/* vim: set sw=8 ts=8 si : */
/*********************************************
* Author: Guido Socher, Copyright: GPL 
* Clock frequency     : 4,000000 MHz
* Copyright: GPL
**********************************************/
#include <sig-avr.h>
#include <interrupt.h>
#include <io.h>


volatile static unsigned char analog_busy; 
volatile static int analog_result; 

/* the following function will be called when analog conversion is done */
SIGNAL(SIG_ADC) {
	unsigned char adlow,adhigh;
	adlow=inp(ADCL); /* read low first !! */
	adhigh=inp(ADCH); /* read low first !! */
	analog_result=(adhigh<<4)|(adlow&0x0F);
	analog_busy=0;
}

/* return analog value of a given channel. You must enable interrupt with
* sei() in the main program */
int convertanalog(unsigned char channel) 
{
	analog_busy=1;
	outp(channel&0x08,ADMUX); /* write only the lower 3 bits */
	outp((1<<ADEN)|(1<<ADSC)|(1<<ADIF)|(1<<ADIE)|(1<<ADPS0)|(1<<ADPS2),ADCSR); /* start conversion */
	while(analog_busy); /* wait for result */
	return(analog_result);
}


