/* vim: set sw=8 ts=8 si : */
/*************************************************************************
*  Title  :   C include file for avr utilities routines
*   Target:    any AVR device
*    Copyright: GPL
*    ***************************************************************************/
#ifndef RUTIL_H
#define RUTIL_H

/* this is basically itoa except that the buffer is allready
* allocated and the convertion is to decimal */
extern char *int2str(unsigned int num);

/* rolltext is used to get a rolling string for the LCD display: */
extern char *rolltext_p(prog_char *text, int shiftlen);
extern char *rolltext(char *text, int shiftlen);
/* convert a string in program memory into a normal string 
*  The string must not be longer than PRGSTRBUF 
*  Use like this: prgstr2str(PSTR("linux")) */
extern char *prgstr2str(prog_char *s);

/*
* The following sprintf function is not a full sprintf. It supports
* only: %c (character), %s or %S (string), %o (octal integer),
* %i (signed interger), %u (unsigned integer), %x (hex)
* The resulting formtted string of each included variable (not the
* whole string) must not be longer than 15 bytes.
*/
extern int sprintf(char * buf, const char * format, ...);
#endif 


