
#include "macros.inc"

#define s1_hi r25
#define s1_lo r24
#define s2_hi r23
#define s2_lo r22
#define len_hi r21
#define len_lo r20

#define ret_hi r25
#define ret_lo r24

; int memcmp(const void *s1, const void *s2, size_t len)

	.text
	.global	_U(memcmp)
	.type	_U(memcmp), @function
_U(memcmp):
	LOAD_Z(s2_lo, s2_hi)
	LOAD_X(s1_lo, s1_hi)
	rjmp	.memcmp_start
.memcmp_loop:
	ld	ret_lo, X+
	ld	__tmp_reg__, Z+
	sub	ret_lo, __tmp_reg__
	brne	.memcmp_done
.memcmp_start:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcc	.memcmp_loop
; strings are equal, so clear both ret_lo and carry
	sub	ret_lo, ret_lo
.memcmp_done:
; ret_hi = SREG.C ? 0xFF : 0
	sbc	ret_hi, ret_hi
	ret
.memcmp_end:
	.size	_U(memcmp), .memcmp_end - _U(memcmp)

