
#include "macros.inc"

#define dest_hi r25
#define dest_lo r24
#define src_hi r23
#define src_lo r22
; #define val_hi r21
#define val_lo r20
#define len_hi r19
#define len_lo r18

#define ret_hi r25
#define ret_lo r24

; void *memccpy(void *dest, const void *src, int val, size_t len)

	.text
	.global	_U(memccpy)
	.type	_U(memccpy), @function
_U(memccpy):
	LOAD_Z(src_lo, src_hi)
	LOAD_X(dest_lo, dest_hi)
.memccpy_loop:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcs	.memccpy_notfound
	ld	__tmp_reg__, Z+
	st	X+, __tmp_reg__
	cp	__tmp_reg__, val_lo
	brne	.memccpy_loop
	mov	ret_lo, XL	; XXX use movw if available
	mov	ret_hi, XH
	ret
.memccpy_notfound:
	clr	ret_lo
	clr	ret_hi
	ret
.memccpy_end:
	.size	_U(memccpy), .memccpy_end - _U(memccpy)

