
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#ifndef __GD_FUNCTION_H  
#define __GD_FUNCTION_H 1  
 
/********************************************************************\  
*              S T A N D A R D    L I B R A R I E S   
\********************************************************************/  
#include <iostream.h>  
 
/********************************************************************\  
*         D E F I N I T I O N S   & D E C L A R A T I O N S  
\********************************************************************/  
typedef  double (*GDfunc1D)(double);  
typedef  double (*GDfunc2D)(double, double);  
typedef  double (*GDfunc3D)(double, double, double);  
 
 
class GdTableFunc1D;  
 
 
/********************************************************************\  
*   G E L + +    F U N C T I O N    H A N D L I N G   O B J E C T S  
\********************************************************************/  
class  GdTableFunc1D {   
/* This object represents a table approximation to a real function  
* of on dimension  
  */  
public:   
	  
  /* Constructors & Destructors */  
  GdTableFunc1D();  
  GdTableFunc1D(GDfunc1D, int, double, double);   
  ~GdTableFunc1D();   
	  
  /* Selector */  
  double evaluate(double) const;        /*   Interpolate value f(x)  */  
  void bounds(double &, double &);      /*   upper and lower bounds  */  
	  
private:  
  friend ostream& operator<<(ostream&, const GdTableFunc1D&);   
	  
protected:   
  int            numberPoints;         /* Number of points in table */  
  double         xmin;                 /* Minimum x supported       */  
  double         xmax;                 /* Maximum x supported       */  
  double         DeltaX;               /* Grid spacing in table     */  
  double        *table;                /* f(x0) f(x1) .... f(xn)    */  
};   
 
 
 
 
 
 
 
#endif  
