// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: prefs.h,v 0.9 2003/02/16 15:03:30 mj Exp $
 *
 * Class for kwatch preferences dialog
 *
 *****************************************************************************
 * Copyright (C) 2000-2003
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *
 * Based on kwatch 0.3, with the following copyright notice:
 *
 * Kwatch is Copyright (C) 1997,1998 Ralph C. Weichert and can be
 * distributed freely under the terms of the GNU General Public License
 * (see file COPYING)
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#ifndef PREFS_H
#define PREFS_H

#include <qlistbox.h>
#include <qcheckbox.h>
#include <qlabel.h>

#include <kdialogbase.h>
#include <knuminput.h>
#include <kurlrequester.h>

#include "kwatchconf.h"



class kwatchPrefs : public KDialogBase
{
    Q_OBJECT

public:
    // static members
    static int  setWidth   (QWidget *, int=0);
    static void setFontFgBg(QWidget *,
			    const QFont &, const QColor &, const QColor &);
    

public:
    kwatchPrefs(QWidget *parent, kwatchConf &cf);
    ~kwatchPrefs();


private:
    // main config
    kwatchConf    &m_cf;
    // local copy
    kwatchConf     m_copy;
    
    // dialog widgets
    QListBox      *m_files;
    QLabel        *m_preview;
    KIntNumInput  *m_param1;
    KIntNumInput  *m_param2;
    QCheckBox     *m_alertCall;
    KURLRequester *m_soundCall;
    QCheckBox     *m_alertLog;
    KURLRequester *m_soundLog;


private slots:
    void addFile();
    void delFile();
    void chooseFont();
    void chooseForeground();
    void chooseBackground();
    void changeParam1(int);
    void changeParam2(int);
    

public:
    void setMainConf();
    void updateConf();
    void openPrefs();


};

#endif

// EOF
