/***************************************************************************
    LibUFO - UI For OpenGL
    copyright         : (C) 2001-2005 by Johannes Schmidt
    email             : schmidtjf at users.sourceforge.net
                             -------------------

    file              : include/ufo/gl/ugl_prototypes.hpp
    begin             : Sat Nov 1 2003
    $Id: ugl_prototypes.hpp,v 1.3 2005/07/15 14:20:51 abmann Exp $
 ***************************************************************************/

/***************************************************************************
 *  This library is free software; you can redistribute it and/or          *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 2.1 of the License, or (at your option) any later version.      *
 *                                                                         *
 * This library is distributed in the hope that it will be useful,         *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * Lesser General Public License for more details.                         *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with this library; if not, write to the Free Software     *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
 ***************************************************************************/

// This was ripped from SDL_glfuncs.h of the SDL project
//   SDL - Simple DirectMedia Layer
//   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002  Sam Lantinga
// (http://www.libsdl.org)

// list of OpenGL functions sorted alphabetically
// These are the methods used internally

#define UFO_GL_PROC_UNUSED(ret,func,params)
UFO_GL_PROC_UNUSED(void,glAccum,(GLenum,GLfloat))
UFO_GL_PROC_UNUSED(void,glAlphaFunc,(GLenum,GLclampf))
UFO_GL_PROC_UNUSED(GLboolean,glAreTexturesResident,(GLsizei,const GLuint*,GLboolean*))
UFO_GL_PROC_UNUSED(void,glArrayElement,(GLint))
UFO_GL_PROC(void,glBegin,(GLenum))
UFO_GL_PROC(void,glBindTexture,(GLenum,GLuint))
UFO_GL_PROC(void,glBitmap,(GLsizei,GLsizei,GLfloat,GLfloat,GLfloat,GLfloat,const GLubyte*))
UFO_GL_PROC(void,glBlendFunc,(GLenum,GLenum))
UFO_GL_PROC_UNUSED(void,glCallList,(GLuint))
UFO_GL_PROC(void,glCallLists,(GLsizei,GLenum,const GLvoid*))
UFO_GL_PROC(void,glClear,(GLbitfield))
UFO_GL_PROC_UNUSED(void,glClearAccum,(GLfloat,GLfloat,GLfloat,GLfloat))
UFO_GL_PROC(void,glClearColor,(GLclampf,GLclampf,GLclampf,GLclampf))
UFO_GL_PROC_UNUSED(void,glClearDepth,(GLclampd))
UFO_GL_PROC_UNUSED(void,glClearIndex,(GLfloat))
UFO_GL_PROC_UNUSED(void,glClearStencil,(GLint))
UFO_GL_PROC_UNUSED(void,glClipPlane,(GLenum,const GLdouble*))
UFO_GL_PROC_UNUSED(void,glColor3b,(GLbyte,GLbyte,GLbyte))
UFO_GL_PROC_UNUSED(void,glColor3bv,(const GLbyte*))
UFO_GL_PROC_UNUSED(void,glColor3d,(GLdouble,GLdouble,GLdouble))
UFO_GL_PROC_UNUSED(void,glColor3dv,(const GLdouble*))
UFO_GL_PROC(void,glColor3f,(GLfloat,GLfloat,GLfloat))
UFO_GL_PROC(void,glColor3fv,(const GLfloat*))
UFO_GL_PROC_UNUSED(void,glColor3i,(GLint,GLint,GLint))
UFO_GL_PROC_UNUSED(void,glColor3iv,(const GLint*))
UFO_GL_PROC_UNUSED(void,glColor3s,(GLshort,GLshort,GLshort))
UFO_GL_PROC_UNUSED(void,glColor3sv,(const GLshort*))
UFO_GL_PROC_UNUSED(void,glColor3ub,(GLubyte,GLubyte,GLubyte))
UFO_GL_PROC_UNUSED(void,glColor3ubv,(const GLubyte*))
UFO_GL_PROC_UNUSED(void,glColor3ui,(GLuint,GLuint,GLuint))
UFO_GL_PROC_UNUSED(void,glColor3uiv,(const GLuint*))
UFO_GL_PROC_UNUSED(void,glColor3us,(GLushort,GLushort,GLushort))
UFO_GL_PROC_UNUSED(void,glColor3usv,(const GLushort*))
UFO_GL_PROC_UNUSED(void,glColor4b,(GLbyte,GLbyte,GLbyte,GLbyte))
UFO_GL_PROC_UNUSED(void,glColor4bv,(const GLbyte*))
UFO_GL_PROC_UNUSED(void,glColor4d,(GLdouble,GLdouble,GLdouble,GLdouble))
UFO_GL_PROC_UNUSED(void,glColor4dv,(const GLdouble*))
UFO_GL_PROC(void,glColor4f,(GLfloat,GLfloat,GLfloat,GLfloat))
UFO_GL_PROC(void,glColor4fv,(const GLfloat*))
UFO_GL_PROC_UNUSED(void,glColor4i,(GLint,GLint,GLint,GLint))
UFO_GL_PROC_UNUSED(void,glColor4iv,(const GLint*))
UFO_GL_PROC_UNUSED(void,glColor4s,(GLshort,GLshort,GLshort,GLshort))
UFO_GL_PROC_UNUSED(void,glColor4sv,(const GLshort*))
UFO_GL_PROC_UNUSED(void,glColor4ub,(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha))
UFO_GL_PROC_UNUSED(void,glColor4ubv,(const GLubyte *v))
UFO_GL_PROC_UNUSED(void,glColor4ui,(GLuint red, GLuint green, GLuint blue, GLuint alpha))
UFO_GL_PROC_UNUSED(void,glColor4uiv,(const GLuint *v))
UFO_GL_PROC_UNUSED(void,glColor4us,(GLushort red, GLushort green, GLushort blue, GLushort alpha))
UFO_GL_PROC_UNUSED(void,glColor4usv,(const GLushort *v))
UFO_GL_PROC_UNUSED(void,glColorMask,(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
UFO_GL_PROC_UNUSED(void,glColorMaterial,(GLenum face, GLenum mode))
UFO_GL_PROC_UNUSED(void,glColorPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
UFO_GL_PROC_UNUSED(void,glCopyPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type))
UFO_GL_PROC_UNUSED(void,glCopyTexImage1D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border))
UFO_GL_PROC_UNUSED(void,glCopyTexImage2D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
UFO_GL_PROC_UNUSED(void,glCopyTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
UFO_GL_PROC_UNUSED(void,glCopyTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
UFO_GL_PROC_UNUSED(void,glCullFace,(GLenum mode))
UFO_GL_PROC(void,glDeleteLists,(GLuint list, GLsizei range))
UFO_GL_PROC(void,glDeleteTextures,(GLsizei n, const GLuint *textures))
UFO_GL_PROC_UNUSED(void,glDepthFunc,(GLenum func))
UFO_GL_PROC_UNUSED(void,glDepthMask,(GLboolean flag))
UFO_GL_PROC_UNUSED(void,glDepthRange,(GLclampd zNear, GLclampd zFar))
UFO_GL_PROC(void,glDisable,(GLenum cap))
UFO_GL_PROC_UNUSED(void,glDisableClientState,(GLenum array))
UFO_GL_PROC(void,glDrawArrays,(GLenum mode, GLint first, GLsizei count))
UFO_GL_PROC_UNUSED(void,glDrawBuffer,(GLenum mode))
UFO_GL_PROC_UNUSED(void,glDrawElements,(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices))
UFO_GL_PROC_UNUSED(void,glDrawPixels,(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
UFO_GL_PROC_UNUSED(void,glEdgeFlag,(GLboolean flag))
UFO_GL_PROC_UNUSED(void,glEdgeFlagPointer,(GLsizei stride, const GLvoid *pointer))
UFO_GL_PROC_UNUSED(void,glEdgeFlagv,(const GLboolean *flag))
UFO_GL_PROC(void,glEnable,(GLenum cap))
UFO_GL_PROC_UNUSED(void,glEnableClientState,(GLenum array))
UFO_GL_PROC(void,glEnd,(void))
UFO_GL_PROC_UNUSED(void,glEndList,(void))
UFO_GL_PROC_UNUSED(void,glEvalCoord1d,(GLdouble u))
UFO_GL_PROC_UNUSED(void,glEvalCoord1dv,(const GLdouble *u))
UFO_GL_PROC_UNUSED(void,glEvalCoord1f,(GLfloat u))
UFO_GL_PROC_UNUSED(void,glEvalCoord1fv,(const GLfloat *u))
UFO_GL_PROC_UNUSED(void,glEvalCoord2d,(GLdouble u, GLdouble v))
UFO_GL_PROC_UNUSED(void,glEvalCoord2dv,(const GLdouble *u))
UFO_GL_PROC_UNUSED(void,glEvalCoord2f,(GLfloat u, GLfloat v))
UFO_GL_PROC_UNUSED(void,glEvalCoord2fv,(const GLfloat *u))
UFO_GL_PROC_UNUSED(void,glEvalMesh1,(GLenum mode, GLint i1, GLint i2))
UFO_GL_PROC_UNUSED(void,glEvalMesh2,(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2))
UFO_GL_PROC_UNUSED(void,glEvalPoint1,(GLint i))
UFO_GL_PROC_UNUSED(void,glEvalPoint2,(GLint i, GLint j))
UFO_GL_PROC_UNUSED(void,glFeedbackBuffer,(GLsizei size, GLenum type, GLfloat *buffer))
UFO_GL_PROC_UNUSED(void,glFinish,(void))
UFO_GL_PROC(void,glFlush,(void))
UFO_GL_PROC_UNUSED(void,glFogf,(GLenum pname, GLfloat param))
UFO_GL_PROC_UNUSED(void,glFogfv,(GLenum pname, const GLfloat *params))
UFO_GL_PROC_UNUSED(void,glFogi,(GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glFogiv,(GLenum pname, const GLint *params))
UFO_GL_PROC_UNUSED(void,glFrontFace,(GLenum mode))
UFO_GL_PROC_UNUSED(void,glFrustum,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
UFO_GL_PROC(GLuint,glGenLists,(GLsizei range))
UFO_GL_PROC(void,glGenTextures,(GLsizei n, GLuint *textures))
UFO_GL_PROC_UNUSED(void,glGetBooleanv,(GLenum pname, GLboolean *params))
UFO_GL_PROC_UNUSED(void,glGetClipPlane,(GLenum plane, GLdouble *equation))
UFO_GL_PROC_UNUSED(void,glGetDoublev,(GLenum pname, GLdouble *params))
UFO_GL_PROC_UNUSED(GLenum,glGetError,(void))
UFO_GL_PROC(void,glGetFloatv,(GLenum pname, GLfloat *params))
UFO_GL_PROC(void,glGetIntegerv,(GLenum pname, GLint *params))
UFO_GL_PROC_UNUSED(void,glGetLightfv,(GLenum light, GLenum pname, GLfloat *params))
UFO_GL_PROC_UNUSED(void,glGetLightiv,(GLenum light, GLenum pname, GLint *params))
UFO_GL_PROC_UNUSED(void,glGetMapdv,(GLenum target, GLenum query, GLdouble *v))
UFO_GL_PROC_UNUSED(void,glGetMapfv,(GLenum target, GLenum query, GLfloat *v))
UFO_GL_PROC_UNUSED(void,glGetMapiv,(GLenum target, GLenum query, GLint *v))
UFO_GL_PROC_UNUSED(void,glGetMaterialfv,(GLenum face, GLenum pname, GLfloat *params))
UFO_GL_PROC_UNUSED(void,glGetMaterialiv,(GLenum face, GLenum pname, GLint *params))
UFO_GL_PROC_UNUSED(void,glGetPixelMapfv,(GLenum map, GLfloat *values))
UFO_GL_PROC_UNUSED(void,glGetPixelMapuiv,(GLenum map, GLuint *values))
UFO_GL_PROC_UNUSED(void,glGetPixelMapusv,(GLenum map, GLushort *values))
UFO_GL_PROC_UNUSED(void,glGetPointerv,(GLenum pname, GLvoid* *params))
UFO_GL_PROC_UNUSED(void,glGetPolygonStipple,(GLubyte *mask))
UFO_GL_PROC(const GLubyte *,glGetString,(GLenum name))
UFO_GL_PROC_UNUSED(void,glGetTexEnvfv,(GLenum target, GLenum pname, GLfloat *params))
UFO_GL_PROC_UNUSED(void,glGetTexEnviv,(GLenum target, GLenum pname, GLint *params))
UFO_GL_PROC_UNUSED(void,glGetTexGendv,(GLenum coord, GLenum pname, GLdouble *params))
UFO_GL_PROC_UNUSED(void,glGetTexGenfv,(GLenum coord, GLenum pname, GLfloat *params))
UFO_GL_PROC_UNUSED(void,glGetTexGeniv,(GLenum coord, GLenum pname, GLint *params))
UFO_GL_PROC_UNUSED(void,glGetTexImage,(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels))
UFO_GL_PROC_UNUSED(void,glGetTexLevelParameterfv,(GLenum target, GLint level, GLenum pname, GLfloat *params))
UFO_GL_PROC_UNUSED(void,glGetTexLevelParameteriv,(GLenum target, GLint level, GLenum pname, GLint *params))
UFO_GL_PROC_UNUSED(void,glGetTexParameterfv,(GLenum target, GLenum pname, GLfloat *params))
UFO_GL_PROC_UNUSED(void,glGetTexParameteriv,(GLenum target, GLenum pname, GLint *params))
UFO_GL_PROC_UNUSED(void,glHint,(GLenum target, GLenum mode))
UFO_GL_PROC_UNUSED(void,glIndexMask,(GLuint mask))
UFO_GL_PROC_UNUSED(void,glIndexPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
UFO_GL_PROC_UNUSED(void,glIndexd,(GLdouble c))
UFO_GL_PROC_UNUSED(void,glIndexdv,(const GLdouble *c))
UFO_GL_PROC_UNUSED(void,glIndexf,(GLfloat c))
UFO_GL_PROC_UNUSED(void,glIndexfv,(const GLfloat *c))
UFO_GL_PROC_UNUSED(void,glIndexi,(GLint c))
UFO_GL_PROC_UNUSED(void,glIndexiv,(const GLint *c))
UFO_GL_PROC_UNUSED(void,glIndexs,(GLshort c))
UFO_GL_PROC_UNUSED(void,glIndexsv,(const GLshort *c))
UFO_GL_PROC_UNUSED(void,glIndexub,(GLubyte c))
UFO_GL_PROC_UNUSED(void,glIndexubv,(const GLubyte *c))
UFO_GL_PROC_UNUSED(void,glInitNames,(void))
UFO_GL_PROC(void,glInterleavedArrays,(GLenum format, GLsizei stride, const GLvoid *pointer))
UFO_GL_PROC_UNUSED(GLboolean,glIsEnabled,(GLenum cap))
UFO_GL_PROC_UNUSED(GLboolean,glIsList,(GLuint list))
UFO_GL_PROC_UNUSED(GLboolean,glIsTexture,(GLuint texture))
UFO_GL_PROC_UNUSED(void,glLightModelf,(GLenum pname, GLfloat param))
UFO_GL_PROC_UNUSED(void,glLightModelfv,(GLenum pname, const GLfloat *params))
UFO_GL_PROC_UNUSED(void,glLightModeli,(GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glLightModeliv,(GLenum pname, const GLint *params))
UFO_GL_PROC_UNUSED(void,glLightf,(GLenum light, GLenum pname, GLfloat param))
UFO_GL_PROC_UNUSED(void,glLightfv,(GLenum light, GLenum pname, const GLfloat *params))
UFO_GL_PROC_UNUSED(void,glLighti,(GLenum light, GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glLightiv,(GLenum light, GLenum pname, const GLint *params))
UFO_GL_PROC(void,glLineStipple,(GLint factor, GLushort pattern))
UFO_GL_PROC(void,glLineWidth,(GLfloat width))
UFO_GL_PROC(void,glListBase,(GLuint base))
UFO_GL_PROC(void,glLoadIdentity,(void))
UFO_GL_PROC_UNUSED(void,glLoadMatrixd,(const GLdouble *m))
UFO_GL_PROC_UNUSED(void,glLoadMatrixf,(const GLfloat *m))
UFO_GL_PROC_UNUSED(void,glLoadName,(GLuint name))
UFO_GL_PROC_UNUSED(void,glLogicOp,(GLenum opcode))
UFO_GL_PROC_UNUSED(void,glMap1d,(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points))
UFO_GL_PROC_UNUSED(void,glMap1f,(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points))
UFO_GL_PROC_UNUSED(void,glMap2d,(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points))
UFO_GL_PROC_UNUSED(void,glMap2f,(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points))
UFO_GL_PROC_UNUSED(void,glMapGrid1d,(GLint un, GLdouble u1, GLdouble u2))
UFO_GL_PROC_UNUSED(void,glMapGrid1f,(GLint un, GLfloat u1, GLfloat u2))
UFO_GL_PROC_UNUSED(void,glMapGrid2d,(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2))
UFO_GL_PROC_UNUSED(void,glMapGrid2f,(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2))
UFO_GL_PROC_UNUSED(void,glMaterialf,(GLenum face, GLenum pname, GLfloat param))
UFO_GL_PROC_UNUSED(void,glMaterialfv,(GLenum face, GLenum pname, const GLfloat *params))
UFO_GL_PROC_UNUSED(void,glMateriali,(GLenum face, GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glMaterialiv,(GLenum face, GLenum pname, const GLint *params))
UFO_GL_PROC(void,glMatrixMode,(GLenum mode))
UFO_GL_PROC_UNUSED(void,glMultMatrixd,(const GLdouble *m))
UFO_GL_PROC_UNUSED(void,glMultMatrixf,(const GLfloat *m))
UFO_GL_PROC_UNUSED(void,glNewList,(GLuint list, GLenum mode))
UFO_GL_PROC_UNUSED(void,glNormal3b,(GLbyte nx, GLbyte ny, GLbyte nz))
UFO_GL_PROC_UNUSED(void,glNormal3bv,(const GLbyte *v))
UFO_GL_PROC_UNUSED(void,glNormal3d,(GLdouble nx, GLdouble ny, GLdouble nz))
UFO_GL_PROC_UNUSED(void,glNormal3dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glNormal3f,(GLfloat nx, GLfloat ny, GLfloat nz))
UFO_GL_PROC_UNUSED(void,glNormal3fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glNormal3i,(GLint nx, GLint ny, GLint nz))
UFO_GL_PROC_UNUSED(void,glNormal3iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glNormal3s,(GLshort nx, GLshort ny, GLshort nz))
UFO_GL_PROC_UNUSED(void,glNormal3sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glNormalPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
UFO_GL_PROC(void,glOrtho,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
UFO_GL_PROC_UNUSED(void,glPassThrough,(GLfloat token))
UFO_GL_PROC_UNUSED(void,glPixelMapfv,(GLenum map, GLsizei mapsize, const GLfloat *values))
UFO_GL_PROC_UNUSED(void,glPixelMapuiv,(GLenum map, GLsizei mapsize, const GLuint *values))
UFO_GL_PROC_UNUSED(void,glPixelMapusv,(GLenum map, GLsizei mapsize, const GLushort *values))
UFO_GL_PROC_UNUSED(void,glPixelStoref,(GLenum pname, GLfloat param))
UFO_GL_PROC(void,glPixelStorei,(GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glPixelTransferf,(GLenum pname, GLfloat param))
UFO_GL_PROC_UNUSED(void,glPixelTransferi,(GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glPixelZoom,(GLfloat xfactor, GLfloat yfactor))
UFO_GL_PROC_UNUSED(void,glPointSize,(GLfloat size))
UFO_GL_PROC(void,glPolygonMode,(GLenum face, GLenum mode))
UFO_GL_PROC_UNUSED(void,glPolygonOffset,(GLfloat factor, GLfloat units))
UFO_GL_PROC_UNUSED(void,glPolygonStipple,(const GLubyte *mask))
UFO_GL_PROC(void,glPopAttrib,(void))
UFO_GL_PROC(void,glPopClientAttrib,(void))
UFO_GL_PROC(void,glPopMatrix,(void))
UFO_GL_PROC_UNUSED(void,glPopName,(void))
UFO_GL_PROC_UNUSED(void,glPrioritizeTextures,(GLsizei n, const GLuint *textures, const GLclampf *priorities))
UFO_GL_PROC(void,glPushAttrib,(GLbitfield mask))
UFO_GL_PROC(void,glPushClientAttrib,(GLbitfield mask))
UFO_GL_PROC(void,glPushMatrix,(void))
UFO_GL_PROC_UNUSED(void,glPushName,(GLuint name))
UFO_GL_PROC_UNUSED(void,glRasterPos2d,(GLdouble x, GLdouble y))
UFO_GL_PROC_UNUSED(void,glRasterPos2dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glRasterPos2f,(GLfloat x, GLfloat y))
UFO_GL_PROC_UNUSED(void,glRasterPos2fv,(const GLfloat *v))
UFO_GL_PROC(void,glRasterPos2i,(GLint x, GLint y))
UFO_GL_PROC_UNUSED(void,glRasterPos2iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glRasterPos2s,(GLshort x, GLshort y))
UFO_GL_PROC_UNUSED(void,glRasterPos2sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glRasterPos3d,(GLdouble x, GLdouble y, GLdouble z))
UFO_GL_PROC_UNUSED(void,glRasterPos3dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glRasterPos3f,(GLfloat x, GLfloat y, GLfloat z))
UFO_GL_PROC_UNUSED(void,glRasterPos3fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glRasterPos3i,(GLint x, GLint y, GLint z))
UFO_GL_PROC_UNUSED(void,glRasterPos3iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glRasterPos3s,(GLshort x, GLshort y, GLshort z))
UFO_GL_PROC_UNUSED(void,glRasterPos3sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glRasterPos4d,(GLdouble x, GLdouble y, GLdouble z, GLdouble w))
UFO_GL_PROC_UNUSED(void,glRasterPos4dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glRasterPos4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
UFO_GL_PROC_UNUSED(void,glRasterPos4fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glRasterPos4i,(GLint x, GLint y, GLint z, GLint w))
UFO_GL_PROC_UNUSED(void,glRasterPos4iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glRasterPos4s,(GLshort x, GLshort y, GLshort z, GLshort w))
UFO_GL_PROC_UNUSED(void,glRasterPos4sv,(const GLshort *v))
UFO_GL_PROC(void,glReadBuffer,(GLenum mode))
UFO_GL_PROC(void,glReadPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels))
UFO_GL_PROC_UNUSED(void,glRectd,(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2))
UFO_GL_PROC_UNUSED(void,glRectdv,(const GLdouble *v1, const GLdouble *v2))
UFO_GL_PROC_UNUSED(void,glRectf,(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2))
UFO_GL_PROC_UNUSED(void,glRectfv,(const GLfloat *v1, const GLfloat *v2))
UFO_GL_PROC(void,glRecti,(GLint x1, GLint y1, GLint x2, GLint y2))
UFO_GL_PROC_UNUSED(void,glRectiv,(const GLint *v1, const GLint *v2))
UFO_GL_PROC_UNUSED(void,glRects,(GLshort x1, GLshort y1, GLshort x2, GLshort y2))
UFO_GL_PROC_UNUSED(void,glRectsv,(const GLshort *v1, const GLshort *v2))
UFO_GL_PROC_UNUSED(GLint,glRenderMode,(GLenum mode))
UFO_GL_PROC_UNUSED(void,glRotated,(GLdouble angle, GLdouble x, GLdouble y, GLdouble z))
UFO_GL_PROC_UNUSED(void,glRotatef,(GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
UFO_GL_PROC_UNUSED(void,glScaled,(GLdouble x, GLdouble y, GLdouble z))
UFO_GL_PROC_UNUSED(void,glScalef,(GLfloat x, GLfloat y, GLfloat z))
UFO_GL_PROC(void,glScissor,(GLint x, GLint y, GLsizei width, GLsizei height))
UFO_GL_PROC_UNUSED(void,glSelectBuffer,(GLsizei size, GLuint *buffer))
UFO_GL_PROC(void,glShadeModel,(GLenum mode))
UFO_GL_PROC_UNUSED(void,glStencilFunc,(GLenum func, GLint ref, GLuint mask))
UFO_GL_PROC_UNUSED(void,glStencilMask,(GLuint mask))
UFO_GL_PROC_UNUSED(void,glStencilOp,(GLenum fail, GLenum zfail, GLenum zpass))
UFO_GL_PROC_UNUSED(void,glTexCoord1d,(GLdouble s))
UFO_GL_PROC_UNUSED(void,glTexCoord1dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glTexCoord1f,(GLfloat s))
UFO_GL_PROC_UNUSED(void,glTexCoord1fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glTexCoord1i,(GLint s))
UFO_GL_PROC_UNUSED(void,glTexCoord1iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glTexCoord1s,(GLshort s))
UFO_GL_PROC_UNUSED(void,glTexCoord1sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glTexCoord2d,(GLdouble s, GLdouble t))
UFO_GL_PROC_UNUSED(void,glTexCoord2dv,(const GLdouble *v))
UFO_GL_PROC(void,glTexCoord2f,(GLfloat s, GLfloat t))
UFO_GL_PROC_UNUSED(void,glTexCoord2fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glTexCoord2i,(GLint s, GLint t))
UFO_GL_PROC_UNUSED(void,glTexCoord2iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glTexCoord2s,(GLshort s, GLshort t))
UFO_GL_PROC_UNUSED(void,glTexCoord2sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glTexCoord3d,(GLdouble s, GLdouble t, GLdouble r))
UFO_GL_PROC_UNUSED(void,glTexCoord3dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glTexCoord3f,(GLfloat s, GLfloat t, GLfloat r))
UFO_GL_PROC_UNUSED(void,glTexCoord3fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glTexCoord3i,(GLint s, GLint t, GLint r))
UFO_GL_PROC_UNUSED(void,glTexCoord3iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glTexCoord3s,(GLshort s, GLshort t, GLshort r))
UFO_GL_PROC_UNUSED(void,glTexCoord3sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glTexCoord4d,(GLdouble s, GLdouble t, GLdouble r, GLdouble q))
UFO_GL_PROC_UNUSED(void,glTexCoord4dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glTexCoord4f,(GLfloat s, GLfloat t, GLfloat r, GLfloat q))
UFO_GL_PROC_UNUSED(void,glTexCoord4fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glTexCoord4i,(GLint s, GLint t, GLint r, GLint q))
UFO_GL_PROC_UNUSED(void,glTexCoord4iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glTexCoord4s,(GLshort s, GLshort t, GLshort r, GLshort q))
UFO_GL_PROC_UNUSED(void,glTexCoord4sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glTexCoordPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
UFO_GL_PROC(void,glTexEnvf,(GLenum target, GLenum pname, GLfloat param))
UFO_GL_PROC_UNUSED(void,glTexEnvfv,(GLenum target, GLenum pname, const GLfloat *params))
UFO_GL_PROC(void,glTexEnvi,(GLenum target, GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glTexEnviv,(GLenum target, GLenum pname, const GLint *params))
UFO_GL_PROC_UNUSED(void,glTexGend,(GLenum coord, GLenum pname, GLdouble param))
UFO_GL_PROC_UNUSED(void,glTexGendv,(GLenum coord, GLenum pname, const GLdouble *params))
UFO_GL_PROC_UNUSED(void,glTexGenf,(GLenum coord, GLenum pname, GLfloat param))
UFO_GL_PROC_UNUSED(void,glTexGenfv,(GLenum coord, GLenum pname, const GLfloat *params))
UFO_GL_PROC_UNUSED(void,glTexGeni,(GLenum coord, GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glTexGeniv,(GLenum coord, GLenum pname, const GLint *params))
UFO_GL_PROC_UNUSED(void,glTexImage1D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
UFO_GL_PROC(void,glTexImage2D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
UFO_GL_PROC_UNUSED(void,glTexParameterf,(GLenum target, GLenum pname, GLfloat param))
UFO_GL_PROC_UNUSED(void,glTexParameterfv,(GLenum target, GLenum pname, const GLfloat *params))
UFO_GL_PROC(void,glTexParameteri,(GLenum target, GLenum pname, GLint param))
UFO_GL_PROC_UNUSED(void,glTexParameteriv,(GLenum target, GLenum pname, const GLint *params))
UFO_GL_PROC_UNUSED(void,glTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels))
UFO_GL_PROC_UNUSED(void,glTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
UFO_GL_PROC_UNUSED(void,glTranslated,(GLdouble x, GLdouble y, GLdouble z))
UFO_GL_PROC(void,glTranslatef,(GLfloat x, GLfloat y, GLfloat z))
UFO_GL_PROC_UNUSED(void,glVertex2d,(GLdouble x, GLdouble y))
UFO_GL_PROC_UNUSED(void,glVertex2dv,(const GLdouble *v))
UFO_GL_PROC(void,glVertex2f,(GLfloat x, GLfloat y))
UFO_GL_PROC_UNUSED(void,glVertex2fv,(const GLfloat *v))
UFO_GL_PROC(void,glVertex2i,(GLint x, GLint y))
UFO_GL_PROC_UNUSED(void,glVertex2iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glVertex2s,(GLshort x, GLshort y))
UFO_GL_PROC_UNUSED(void,glVertex2sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glVertex3d,(GLdouble x, GLdouble y, GLdouble z))
UFO_GL_PROC_UNUSED(void,glVertex3dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glVertex3f,(GLfloat x, GLfloat y, GLfloat z))
UFO_GL_PROC_UNUSED(void,glVertex3fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glVertex3i,(GLint x, GLint y, GLint z))
UFO_GL_PROC_UNUSED(void,glVertex3iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glVertex3s,(GLshort x, GLshort y, GLshort z))
UFO_GL_PROC_UNUSED(void,glVertex3sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glVertex4d,(GLdouble x, GLdouble y, GLdouble z, GLdouble w))
UFO_GL_PROC_UNUSED(void,glVertex4dv,(const GLdouble *v))
UFO_GL_PROC_UNUSED(void,glVertex4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
UFO_GL_PROC_UNUSED(void,glVertex4fv,(const GLfloat *v))
UFO_GL_PROC_UNUSED(void,glVertex4i,(GLint x, GLint y, GLint z, GLint w))
UFO_GL_PROC_UNUSED(void,glVertex4iv,(const GLint *v))
UFO_GL_PROC_UNUSED(void,glVertex4s,(GLshort x, GLshort y, GLshort z, GLshort w))
UFO_GL_PROC_UNUSED(void,glVertex4sv,(const GLshort *v))
UFO_GL_PROC_UNUSED(void,glVertexPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
UFO_GL_PROC(void,glViewport,(GLint x, GLint y, GLsizei width, GLsizei height))


//
// FIXME
// GLU prototypes
// should be removed
/*
#define UFO_GLU_PROC_UNUSED(ret,func,params)
UFO_GLU_PROC(GLint,gluBuild2DMipmaps,(GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *data))
UFO_GLU_PROC(GLint,gluScaleImage,(GLenum format, GLsizei wIn, GLsizei hIn, GLenum typeIn, const void *dataIn, GLsizei wOut, GLsizei hOut, GLenum typeOut, GLvoid* dataOut))
UFO_GLU_PROC(const GLubyte*,gluErrorString,(GLenum error))
*/
