/***************************************************************************
                          export.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          export.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Oct 30 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/**********************************************************************

	--- Qt Architect generated file ---

	File: export.cpp
	Last generated: Mon Oct 30 23:47:47 2000

 *********************************************************************/

#include "kmessagebox.h"
#include "export.h"
#include "resource.h"
#include "kfiledialog.h"
#include "qfile.h"
#include "qtextstream.h"
#include "assert.h"
#include "kapp.h"

#define Inherited ExportData

Export::Export(QWidget* parent,	const char* name)	:
	Inherited( parent, name ), sql1(DB_NAME), sql2(DB_NAME), flagcancel(false), isrunning(false)
{
	progress->setEnabled(false);	
	progresslabel->setEnabled(false);	
	year->setValue(2000);
}


Export::~Export() {
}

void Export::choosedir() {
	dir->setText(KFileDialog::getExistingDirectory("/",this));	
}

QString Export::getDir() {
	return dir->text();
}

QString Export::getDateTime() {
	QString s(year->text());
	s+=QString("-")+month->text()+QString("-")+day->text()+QString(" ")+hour->text()+QString(":")+minute->text();
	return s;
}

bool Export::exportModified() {
	return modified->isChecked();
}

bool Export::exportCreated() {
	return modified->isChecked();
}

QString Export::buildClause(QString table) {
	QString s("SELECT * from ");
	s+=table;
	s+=" where ";
	if(exportCreated())
		s+="created > ";
	else
		s+="modified > ";
	s+="'"+getDateTime();
	s+="'";
	return s;
}

void Export::writeTable(QString table, QString lo) {
	if(flagcancel) return;
	progresslabel->setText( ("Exporting "+table)+"..." );
	progress->reset();
	QFile f( (getDir()+"/"+table) );
	f.open(IO_WriteOnly);
	QTextStream s(&f);
	sql1.exec("begin");
	sql1.exec(buildClause(table));

	progress->setTotalSteps(sql1.tuples());

	for(int j=0; j<sql1.fields()-1; j++) {
			s<<sql1.fieldName(j);
			s<<",";
	}
	s<<sql1.fieldName(sql1.fields()-1);

	for(int i=0; i<sql1.tuples(); i++) {
		progress->setProgress(i);
		if(flagcancel) return;

		s<<"\n";
		if(!lo.isEmpty()) {
		  int lfd=0;
		  char *buf=0L;

			Oid k=str2oid(sql1.getValue(i, lo));
		  if(k!=InvalidOid) {
				QFile l(getDir()+QString("/")+sql1.getValue(i, lo));
				l.open(IO_WriteOnly);
				sql2.exec("begin");
			  lfd=sql2.lOpen(k, INV_READ);
			  sql2.lSeek(lfd, 0, SEEK_END);
			  long len=sql2.lTell(lfd);
				int block=1000000;
				int start=0;
				do {
					if(flagcancel) return;
			  	sql2.lSeek(lfd, start, SEEK_SET);
					long blsize=(len-start<block)?len-start:block;
				  buf=new char[blsize];
				  assert(buf);
			  	sql2.lRead(lfd, buf, blsize);
					l.writeBlock(buf, blsize);
					delete buf;
					start+=blsize;
					kapp->processEvents();
				} while(start<len);
				l.close();
			  sql2.lClose(lfd);
				sql2.exec("end");
			}
		}
		
		for(int j=0; j<sql1.fields()-1; j++) {
			if(sql1.fieldIsText(j))
				s<<"'";
			s<<sql1.getValue(i, j);
			if(sql1.fieldIsText(j))
				s<<"'";
			s<<",";
		}
		if(sql1.fieldIsText(sql1.fields()-1))
			s<<"'";
		s<<sql1.getValue(i, sql1.fields()-1);
		if(sql1.fieldIsText(sql1.fields()-1))
			s<<"'";
	}

	f.close();
	sql1.exec("end");
}

void Export::ok() {
	if(!exportCreated() && !exportModified()) {
  	KMessageBox::error(this, "No export option marked!", "Error");
		return;
	}
	isrunning=true;
	day->setEnabled(false);
	month->setEnabled(false);
	year->setEnabled(false);
	hour->setEnabled(false);
	minute->setEnabled(false);
	modified->setEnabled(false);
	created->setEnabled(false);
	chdir->setEnabled(false);
	ok_b->setEnabled(false);
	progress->setEnabled(true);	
	progresslabel->setEnabled(true);	

	writeTable("author", "memo");
	writeTable("part", "memo");
	writeTable("partdata", "file");
	writeTable("publisher");
	writeTable("publication", "memo");
	writeTable("publication_author");
	writeTable("part_author");
	writeTable("note", "memo");
	writeTable("link");
	ExportData::accept();
}

void Export::cancel() {
	if(isrunning)
		flagcancel=true;
	else
	reject();
}
