/***************************************************************************
                          editor.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editor.h"
#include <qfontdatabase.h>
#include <qcolordialog.h>
#include <qaction.h>
#include <qcolor.h>
#include <qtoolbar.h>
#include <klocale.h>
#include <qcombobox.h>
#include <qapplication.h>
#include <qlineedit.h>
#include <qstylesheet.h>
#include <kiconloader.h>
#include <qregexp.h>

MyTextEdit::MyTextEdit(QWidget * parent=0, const char * name=0 ):
  QTextEdit(parent, name) {
  connect(this, SIGNAL(returnPressed()), this, SLOT(slotReturnPressed()));
}

void MyTextEdit::slotReturnPressed() {
  int p,i;
  getCursorPosition(&p, &i);
  setParagType( QStyleSheetItem::DisplayBlock, QStyleSheetItem::ListDisc );
  // insertParagraph("np", p);
}

QString MyTextEdit::text() const {
  QString s=QTextEdit::text();
  debug("Ursprnglicher String:");
  debug(s);
  s.stripWhiteSpace();
  s.replace(QRegExp("<br>"), "<p>&nbsp;</p>");
//  s.replace(QRegExp("\n"), "<p>&nbsp;</p>");
  debug("Nach Replace:");
  debug(s);
//  s.replace(QRegExp("\n"), "<p></p>");
/*
  if(s.find("<p>", 0, false)>0)
    s="<p>"+s;
  if(s.findRev("</p>", 0, false)>0)
    s=s+"</p>";
*/
  return s;
}


Editor::Editor(QWidget * parent=0, const char * name=0, WFlags f=0 ):
	KaspaWidget(parent, name, f), memo(0L) {
 };

  /* The following code is copied from the qt-memo example and slightly modified. */

void Editor::setupEditorConnections() {
  connect( memo, SIGNAL( currentFontChanged( const QFont & ) ),
           this, SLOT( fontChanged( const QFont & ) ) );
  connect( memo, SIGNAL( currentColorChanged( const QColor & ) ),
           this, SLOT( colorChanged( const QColor & ) ) );
  connect( memo, SIGNAL( currentAlignmentChanged( int ) ),
           this, SLOT( alignmentChanged( int ) ) );
  memo->setTextFormat(Qt::RichText);
  memo->styleSheet()->item("p")->setMargin(QStyleSheetItem::MarginVertical, 0);
//  memo->styleSheet()->item("p")->setWhiteSpaceMode(QStyleSheetItem::WhiteSpacePre);
//  memo->styleSheet()->item("qt")->setWhiteSpaceMode(QStyleSheetItem::WhiteSpacePre);
}

void Editor::setupToolbar(QToolBar *toolbar) {

  toolbar->setLabel( "Edit Actions" );
  QAction *a;
  a = new QAction( i18n( "Undo" ), BarIcon( "editundo.xpm" ), i18n( "&Undo" ), CTRL + Key_Z, this, "editUndo" );
  connect( a, SIGNAL( activated() ), this, SLOT( editUndo() ) );
  a->addTo( toolbar );
  a = new QAction( i18n( "Redo" ), BarIcon( "editredo.xpm" ), i18n( "&Redo" ), CTRL + Key_Y, this, "editRedo" );
  connect( a, SIGNAL( activated() ), this, SLOT( editRedo() ) );
  a->addTo( toolbar );
/*
  a = new QAction( i18n( "Copy" ), BarIcon( "editcopy.xpm" ), i18n( "&Copy" ), CTRL + Key_C, this, "editCopy" );
  connect( a, SIGNAL( activated() ), this, SLOT( editCopy() ) );
  a->addTo( toolbar );
  a = new QAction( i18n( "Cut" ), BarIcon( "editcut.xpm" ), i18n( "Cu&t" ), CTRL + Key_X, this, "editCut" );
  connect( a, SIGNAL( activated() ), this, SLOT( editCut() ) );
  a->addTo( toolbar );
  a = new QAction( i18n( "Paste" ), BarIcon( "editpaste.xpm" ), i18n( "&Paste" ), CTRL + Key_V, this, "editPaste" );
  connect( a, SIGNAL( activated() ), this, SLOT( editPaste() ) );
  a->addTo( toolbar );
*/
/*
  comboStyle = new QComboBox( FALSE, toolbar );
  comboStyle->insertItem( "Standard" );
  comboStyle->insertItem( "Bullet List (Disc)" );
  comboStyle->insertItem( "Bullet List (Circle)" );
  comboStyle->insertItem( "Bullet List (Square)" );
  comboStyle->insertItem( "Ordered List (Decimal)" );
  comboStyle->insertItem( "Ordered List (Alpha lower)" );
  comboStyle->insertItem( "Ordered List (Alpha upper)" );
  connect( comboStyle, SIGNAL( activated( int ) ),
    this, SLOT( textStyle( int ) ) );
*/
  comboFont = new QComboBox( TRUE, toolbar );
  QFontDatabase db;
  comboFont->insertStringList( db.families() );
  connect( comboFont, SIGNAL( activated( const QString & ) ),
    this, SLOT( textFamily( const QString & ) ) );
  comboFont->lineEdit()->setText( QApplication::font().family() );

  comboSize = new QComboBox( TRUE, toolbar );
  QValueList<int> sizes = db.standardSizes();
  QValueList<int>::Iterator it = sizes.begin();
  for ( ; it != sizes.end(); ++it )
    comboSize->insertItem( QString::number( *it ) );

  connect( comboSize, SIGNAL( activated( const QString & ) ),
           this, SLOT( textSize( const QString & ) ) );
  comboSize->lineEdit()->setText( QString::number( QApplication::font().pointSize() ) );

  actionTextBold = new QAction( i18n( "Bold" ), BarIcon( "textbold.xpm" ), i18n( "&Bold" ), CTRL + Key_B, this, "textBold" );
  connect( actionTextBold, SIGNAL( activated() ), this, SLOT( textBold() ) );
  actionTextBold->addTo( toolbar );
  actionTextBold->setToggleAction( TRUE );
  actionTextItalic = new QAction( i18n( "Italic" ), BarIcon( "textitalic.xpm" ), i18n( "&Italic" ), CTRL + Key_I, this, "textItalic" );
  connect( actionTextItalic, SIGNAL( activated() ), this, SLOT( textItalic() ) );
  actionTextItalic->addTo( toolbar );
  actionTextItalic->setToggleAction( TRUE );
  actionTextUnderline = new QAction( i18n( "Underline" ), BarIcon( "textunder.xpm" ), i18n( "&Underline" ), CTRL + Key_U, this, "textUnderline" );
  connect( actionTextUnderline, SIGNAL( activated() ), this, SLOT( textUnderline() ) );
  actionTextUnderline->addTo( toolbar );
  actionTextUnderline->setToggleAction( TRUE );

  QActionGroup *grp = new QActionGroup( this );
  grp->setExclusive( TRUE );
  connect( grp, SIGNAL( selected( QAction* ) ), this, SLOT( textAlign( QAction* ) ) );

  actionAlignLeft = new QAction( i18n( "Left" ), BarIcon( "textleft.xpm" ), i18n( "&Left" ), CTRL + Key_L, grp, "textLeft" );
  actionAlignLeft->addTo( toolbar );
  actionAlignLeft->setToggleAction( TRUE );
  actionAlignCenter = new QAction( i18n( "Center" ), BarIcon( "textcenter.xpm" ), i18n( "C&enter" ), CTRL + Key_E, grp, "textCenter" );
  actionAlignCenter->addTo( toolbar );
  actionAlignCenter->setToggleAction( TRUE );
  actionAlignRight = new QAction( i18n( "Right" ), BarIcon( "textright.xpm" ), i18n( "&Right" ), CTRL + Key_R, grp, "textRight" );
  actionAlignRight->addTo( toolbar );
  actionAlignRight->setToggleAction( TRUE );
  actionAlignJustify = new QAction( i18n( "Justify" ), BarIcon( "textjustify.xpm" ), i18n( "&Justify" ), CTRL + Key_J, grp, "textjustify" );
  actionAlignJustify->addTo( toolbar );
  actionAlignJustify->setToggleAction( TRUE );

  QPixmap pix( 16, 16 );
  pix.fill( black );
  actionTextColor = new QAction( i18n( "Color" ), pix, i18n( "&Color..." ), 0, this, "textColor" );
  connect( actionTextColor, SIGNAL( activated() ), this, SLOT( textColor() ) );
  actionTextColor->addTo( toolbar );

}


void Editor::editUndo()
{
    if ( !memo )
	return;
    memo->undo();
}

void Editor::editRedo()
{
    if ( !memo )
	return;
    memo->redo();
}

void Editor::editCut()
{
    if ( !memo )
	return;
    memo->cut();
}

void Editor::editCopy()
{
    if ( !memo )
	return;
    memo->copy();
}

void Editor::editPaste()
{
    if ( !memo )
	return;
    memo->paste();
}

void Editor::textBold()
{
    if ( !memo )
	return;
    memo->setBold( actionTextBold->isOn() );
}

void Editor::textUnderline()
{
    if ( !memo )
	return;
    memo->setUnderline( actionTextUnderline->isOn() );
}

void Editor::textItalic()
{
    if ( !memo )
	return;
    memo->setItalic( actionTextItalic->isOn() );
}

void Editor::textFamily( const QString &f )
{
    if ( !memo )
	return;
    memo->setFamily( f );
    memo->viewport()->setFocus();
}

void Editor::textSize( const QString &p )
{
    if ( !memo )
	return;
    memo->setPointSize( p.toInt() );
    memo->viewport()->setFocus();
}

void Editor::textStyle( int i )
{
    if ( !memo )
	return;
    if ( i == 0 )
  memo->setParagType( QStyleSheetItem::DisplayBlock, QStyleSheetItem::ListDisc );
    else if ( i == 1 )
	memo->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListDisc );
    else if ( i == 2 )
	memo->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListCircle );
    else if ( i == 3 )
	memo->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListSquare );
    else if ( i == 4 )
	memo->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListDecimal );
    else if ( i == 5 )
	memo->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListLowerAlpha );
    else if ( i == 6 )
	memo->setParagType( QStyleSheetItem::DisplayListItem, QStyleSheetItem::ListUpperAlpha );
    memo->viewport()->setFocus();
}

void Editor::textColor()
{
    if ( !memo )
	return;
    QColor col = QColorDialog::getColor( memo->color(), this );
    if ( !col.isValid() )
	return;
    memo->setColor( col );
    QPixmap pix( 16, 16 );
    pix.fill( black );
    actionTextColor->setIconSet( pix );
}

void Editor::textAlign( QAction *a )
{
    if ( !memo )
	return;
    if ( a == actionAlignLeft )
	memo->setAlignment( AlignLeft );
    else if ( a == actionAlignCenter )
	memo->setAlignment( AlignHCenter );
    else if ( a == actionAlignRight )
	memo->setAlignment( AlignRight );
    else if ( a == actionAlignJustify )
	memo->setAlignment( AlignJustify );
}

void Editor::fontChanged( const QFont &f )
{
    comboFont->lineEdit()->setText( f.family() );
    comboSize->lineEdit()->setText( QString::number( f.pointSize() ) );
    actionTextBold->setOn( f.bold() );
    actionTextItalic->setOn( f.italic() );
    actionTextUnderline->setOn( f.underline() );
}

void Editor::colorChanged( const QColor &c )
{
    QPixmap pix( 16, 16 );
    pix.fill( c );
    actionTextColor->setIconSet( pix );
}

void Editor::alignmentChanged( int a )
{
    if ( ( a == AlignAuto ) || ( a & AlignLeft ))
	actionAlignLeft->setOn( TRUE );
    else if ( ( a & AlignHCenter ) )
	actionAlignCenter->setOn( TRUE );
    else if ( ( a & AlignRight ) )
	actionAlignRight->setOn( TRUE );
    else if ( ( a & AlignJustify ) )
	actionAlignJustify->setOn( TRUE );
}
