
/***************************************************************************
                          notebase.cpp  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <assert.h>
#include <stdlib.h>
#include "notebase.h"
#define Inherited Table

// Creates new Note
NoteBase::NoteBase(Sql *conn):Inherited("note", conn) {
	initNew();
}

NoteBase::NoteBase(const char *dbname):Inherited("note", dbname) {
	initNew();
}

void NoteBase::initNew() {
  NoteRec *note=new NoteRec;
  assert(note);
  note->empty();
  note->id.set(newNote());
  init(note);
  _where="where note.no=";
  _where+=note->id.get();
}

NoteBase::NoteBase(const char *where, const char *dbname):Inherited("note", dbname) {
	initWhere(where);
}

NoteBase::NoteBase(const char *where, Sql *conn):Inherited("note", conn) {
	initWhere(where);
}

void NoteBase::initWhere(const char *where) {
  NoteRec *note=Inherited::getNote(where);
  if(!note) {
    note=new NoteRec;
    assert(note);
    note->empty();
    note->id.set((Oid)InvalidOid);
  }
  init(note);
	if(where) _where=where;
	else _where="";            	
}

NoteBase::~NoteBase() throw() {
}

const char *NoteBase::getTitle() {
    return note()->title.get();
}

int NoteBase::getType() {
    return note()->type.get();
}

Oid NoteBase::getPublNo() {
    return note()->publno.get();
}

const char *NoteBase::getMemo() {
    return note()->memo.get();
}

const char *NoteBase::getModified() {
  return note()->modified.get();
}

const char *NoteBase::getCreated() {
  return note()->created.get();
}

void NoteBase::setTitle(const char *s) {
  note()->title.set(s);
  note()->title.setChanged();
}

void NoteBase::setType(int t) {
  note()->type.set(t);
  note()->type.setChanged();
}

void NoteBase::setPublNo(Oid publ) {
  note()->publno.set(publ);
  note()->publno.setChanged();
}


void NoteBase::setMemo(const char *s) {
  note()->memo.set(s);
  note()->memo.setChanged();
}


void NoteBase::write(const char *where, bool block) {
    updateNote(note(), where, block);
}

void NoteBase::del(const Oid o) {
		Str s=Str("where note.no=");
		oid2str(o,&s);
    deleteNote(s);
    note()->empty();
    note()->id.set((Oid)InvalidOid);
}

NoteRec *NoteBase::note() {
	if(!dynamic_cast<NoteRec*>(rec))
		abort();
	return dynamic_cast<NoteRec*>(rec);
}

KaspaRec *NoteBase::invalid() {
  NoteRec *note=new NoteRec();
  assert(note);
  note->id.set((Oid)InvalidOid);
	return note;
}

KaspaRec *NoteBase::read(const char *where) {
  return getNote(where);
}


Oid NoteBase::createNote() {
	Oid o=newNote();
	insertLink(o);
	return o;
}

NoteTitle *NoteBase::getNoteTitles(const char *where) {
  return Inherited::getNoteTitles(where);
}
