/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifndef FAXFILER_H
#define FAXFILER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qsplitter.h>
#include <qwidget.h>
#include <qstring.h>

#include <kconfig.h>

#include "folderview.h"
#include "faxview.h"



class FaxFiler: public QSplitter
{
	Q_OBJECT
public:
	FaxFiler(QWidget *parent = 0, const char *name = 0);
	~FaxFiler();

	void setInboxFolder();

	void readOptions();
	void saveOptions();

	void saveCurrentFolder();

	void newFaxItem(const QString& name);

	QString currentPath();
	QString currentFaxName();
	void setCurrentFaxNew(bool isnew);
	bool currentFaxNew();
	QString currentFaxSender();

	void deleteFax(bool all);

		
	void setFolder(FolderViewItem *folder);
	void takeFaxItem(FolderViewItem *folder, const QString& name, bool isnew);
	void moveFax(const QString& name, FolderViewItem *to, bool copy);
	void moveFax(FolderViewItem *to, bool copy, bool all);
	void deleteFax(FolderViewItem *folder, const QString& name);
	void selectAllFax();

	void setFaxNew(const QString& name, bool isnew);
	int rebuildFolder();
	int rebuildFolder(FolderViewItem *folder);

	void updateFromPre21();

	void newFolder();
	void renameFolder();
	void removeFolder();
	
public slots:
	void moveCallback(FolderViewItem *to);
	void copyCallback(FolderViewItem *to);
	void emptyFolder();

private slots:
	void folderHasCurrentSlot(FolderViewItem *folder);
	void faxHasCurrentSlot(bool);
	void faxHasSelectionSlot(bool);
	void commandSlot(int id_);

signals:
	void hasCurrentFolder(bool, bool);
	void hasCurrentFax(bool);
	void command(int);

private:
	KConfig *config;
	FolderView *folderlist;
	FolderViewItem *current_folder;
	FaxView *faxlist;
};


#endif // FAXFILER_H
