/***************************************************************************
                          dlgconnect.cpp
                        -------------------
    description          : Connect Dialog Class
    begin                : Sun Sep 5 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlgconnect.h"

DlgConnect::DlgConnect(QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Quick Connect"));

	initDialog();

	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );

}


DlgConnect::~DlgConnect(){

	// no need to delete widgets that are children of this class
	// since they will be destroyed when destroying the parent
	// see: ~QObject()

}


QString DlgConnect::getHost(){
	return host_LineEdit->text();
}

QString DlgConnect::getPort(){
	return port_LineEdit->text();
}

void DlgConnect::setHost(QString s){
	host_LineEdit->setText(s);
}

void DlgConnect::setPort(QString s){
	return port_LineEdit->setText(s);
}


void DlgConnect::slotOKPressed()
{
	QString s = host_LineEdit->text();

	if (s.isEmpty())
	{
		QMessageBox nohost( "kmud",i18n("Please name the host"),QMessageBox::Information,
		QMessageBox::Ok | QMessageBox::Default,0,0,this,"nohost_MessageBox",TRUE,0);
		nohost.exec();
	}
	else accept();
}

