/***************************************************************************
                          dlgmapspeedwalk.cpp
                      -------------------
    description          :
    begin                : Thu Jan 18 2001
    copyright            : (C) 2001 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgmapspeedwalk.h"

#include <kiconloader.h>

DlgMapSpeedwalk::DlgMapSpeedwalk(CMapWidget *mWidget,CMapData *data,QWidget *parent, const char *name) : QWidget(parent,name)
{
	initDialog();
	
	lstSpeedwalk->addColumn("Locations",-1);
	lstSpeedwalk->setMultiSelection(false);
	lstSpeedwalk->setSorting(0,true);
	lstSpeedwalk->setColumnWidthMode(0,QListView::Maximum);

	QList<SpeedwalkElement> roomLevel;
	QList<SpeedwalkElement> zoneLevel;

	cboCategorize->setCurrentItem(data->speedwalkCatogrize);
	cmdSpeedwalk->setPixmap(Icon("kmud_follow.xpm"));
	cmdDelete->setPixmap(Icon("delete.xpm"));	
	cmdProperties->setPixmap(Icon("kmud_properties.xpm"));		
	
	connect(cboCategorize,SIGNAL(activated(int)),SLOT(updateSpeedwalkList()));   	
	connect(cmdDelete,SIGNAL(clicked()),SLOT(slotDelete()));
	connect(cmdSpeedwalk,SIGNAL(clicked()),SLOT(slotSpeedwalk()));
	connect(cmdProperties,SIGNAL(clicked()),SLOT(slotProperties()));
	connect(lstSpeedwalk, SIGNAL(doubleClicked(QListViewItem*)), SLOT(slotDoubleClicked(QListViewItem*)));	
	connect(lstSpeedwalk, SIGNAL(returnPressed(QListViewItem*)), SLOT(slotDoubleClicked(QListViewItem*)));	
	
	mapData = data;
	mapWidget = mWidget;
}

DlgMapSpeedwalk::~DlgMapSpeedwalk()
{
}

void DlgMapSpeedwalk::resizeEvent(QResizeEvent *e)
{
	QSize size = e->size();
	lstSpeedwalk->resize(size.width(),size.height()-lstSpeedwalk->y()-cmdDelete->height()-10);	
	cmdDelete->move(cmdDelete->x(),size.height()-cmdDelete->height()-5);
	cmdProperties->move(cmdProperties->x(),size.height()-cmdProperties->height()-5);	
	cmdSpeedwalk->move(cmdSpeedwalk->x(),size.height()-cmdSpeedwalk->height()-5);	
	emit resizeSpeedwalk(size.width());
}

/** Get the currently selected room */
CMapRoom *DlgMapSpeedwalk::getRoom(QListViewItem *current)
{
	QString tempStr;
	CMapRoom *result =NULL;
	roomLevel.clear();
	zoneLevel.clear();
						
	QString strCurrent = current->text(0);

	for (CMapRoom *room = mapData->speedwalkList.first(); room != 0; room = mapData->speedwalkList.next())
	{
		QString roomName =getRoomName(room);
		if (roomName == strCurrent)
		{
			result = room;
			break;
		}
	}
	return result;
}

/* Used to get the room name */
QString DlgMapSpeedwalk::getRoomName(CMapRoom *room)
{			
	QString label =room->getLabel().stripWhiteSpace();
	QString label2;
	if (label.isEmpty()) label = i18n("Unamed room");

	label2 = label;
	int count = countElements(&roomLevel,label2);

	if (count>0)
	{
		QString tempStr;
		tempStr.sprintf(" <%d>",count);	
		label+=tempStr;
	}
	else
	{
		SpeedwalkElement *element = new SpeedwalkElement;

		element->name = label2;
		element->count = count;
		roomLevel.append(element);
	}

	return label;
}

/** Used to display the speed walk list */
void DlgMapSpeedwalk::updateSpeedwalkList(void)
{
	updateSpeedwalkList(NULL);
}

/** Used to display the speed walk list */
void DlgMapSpeedwalk::updateSpeedwalkList(CMapRoom *updatedRoom)
{
	QString tempStr;
	QListViewItem *foundItem = NULL;
	roomLevel.clear();
	zoneLevel.clear();
	
    lstSpeedwalk->clear();

	mapData->speedwalkCatogrize = cboCategorize->currentItem();

	if (mapData->speedwalkCatogrize==0)
	{		
		lstSpeedwalk->setRootIsDecorated (false);	
		for (CMapRoom *room = mapData->speedwalkList.first(); room != 0; room = mapData->speedwalkList.next())
		{
			QListViewItem *newItem = new QListViewItem (lstSpeedwalk,getRoomName(room));
			if (room == updatedRoom) foundItem = newItem;
		}
	}

	if (mapData->speedwalkCatogrize==1)
	{		
		lstSpeedwalk->setRootIsDecorated (true);		
		for (CMapRoom *room = mapData->speedwalkList.first(); room != 0; room = mapData->speedwalkList.next())
		{
			QString roomName = getRoomName(room);
			QListViewItem *tmpItem =findZone(room);
			QListViewItem *newItem = new QListViewItem (tmpItem,roomName);

			if (room == updatedRoom) foundItem = newItem;
		}
	}

	if (mapData->speedwalkCatogrize==2)
	{		
		lstSpeedwalk->setRootIsDecorated (true);		
		for (CMapRoom *room = mapData->speedwalkList.first(); room != 0; room = mapData->speedwalkList.next())
		{
			QListViewItem *newItem = new QListViewItem (findLevel(room),getRoomName(room));	
			if (room == updatedRoom) foundItem = newItem;	
		}
	}

	if (foundItem)
	{
		switch (mapData->speedwalkCatogrize)
		{
			case 0 : lstSpeedwalk->setOpen(foundItem->parent(),true);
			         break;
			case 1 : lstSpeedwalk->setOpen(foundItem->parent()->parent(),true);
			         lstSpeedwalk->setOpen(foundItem->parent(),true);
			         break;
			case 2 : lstSpeedwalk->setOpen(foundItem->parent()->parent()->parent(),true);
			         lstSpeedwalk->setOpen(foundItem->parent()->parent(),true);
			         lstSpeedwalk->setOpen(foundItem->parent(),true);
			         break;
		}


		lstSpeedwalk->setOpen(foundItem,true);
		lstSpeedwalk->ensureItemVisible(foundItem);
		lstSpeedwalk->setCurrentItem(foundItem);
		lstSpeedwalk->setSelected(foundItem,true);
	}
}

/** Used to count the number of times a elements in a given level list*/
int DlgMapSpeedwalk::countElements(QList<SpeedwalkElement> *lstLevel,QString element)
{
	int result = 0;

	for (SpeedwalkElement *e = lstLevel->first();e!=0;e=lstLevel->next())
	{
		if (e->name==element)
		{
			e->count++;
			result=e->count;
			break;
		}
	}
	
	return result;
}

/** Used to get the zone name and get correct name for unamed zones */
QString DlgMapSpeedwalk::getZoneName(CMapZone *zone)
{
	QString result;
	int count =0;
	
	if (zone->getName().stripWhiteSpace().isEmpty())
		result = i18n("Unamed Zone");
	else
		result = zone->getName().stripWhiteSpace();
		
	bool found = false;
	for (CMapZone *zone2 = mapData->zoneList.first();zone2!=0;zone2=mapData->zoneList.next())
	{
		if (zone2->getName() == result)
		{
			count++;
		}

		if (zone2==zone)
		{
			found = true;
			break;
		}
	}

	if (count>1)
	{
		QString unamedCountStr;
		unamedCountStr.sprintf(" <%d>",count-1);	
		result+=unamedCountStr;
	}


	return result;
}

/** Used to find the zone for the zone/room catogery */
QListViewItem *DlgMapSpeedwalk::findZone(CMapRoom *room)
{
	QListViewItem * myChild = lstSpeedwalk->firstChild();
	bool found = false;
    QString zoneName =  getZoneName(room->getZone());
	
	while( myChild )
	{
		QString zone = QString(myChild->text(0));
		if (zone==zoneName)
		{
			found = true;
			break;
		}

		myChild = myChild->nextSibling();	
	}

	if (!found)
	{		

		myChild = new QListViewItem(lstSpeedwalk,zoneName);		
	}

	return myChild;
}
	
/** Used to find the zone for the 	zone/room catogery */
QListViewItem *DlgMapSpeedwalk::findLevel(CMapRoom *room)
{
	QListViewItem * zoneItem = lstSpeedwalk->firstChild();
	QListViewItem * levelItem;	
	bool foundZone = false;
	bool foundLevel = false;
	QString level;
	level.sprintf(i18n("Level %d"),room->getLevel());	
	QString zoneName = getZoneName(room->getZone());
	
	while( zoneItem )
	{
		QString zone = QString(zoneItem->text(0));
		if (zone==zoneName)
		{					
	        levelItem = zoneItem->firstChild();
	
	        while( levelItem)
	        {
	        	if (level == levelItem->text(0))
	        	{
	        		foundLevel = true;
	        		break;
	        	}
	        	
	        	levelItem = levelItem->nextSibling();
	        }
			
			
			foundZone = true;
			break;
		}
		
		zoneItem = zoneItem->nextSibling();	
	}

	if (!foundZone)
	{		
		zoneItem = new QListViewItem(lstSpeedwalk,zoneName);		
	}
	
	if (!foundLevel)
	{
		levelItem = new QListViewItem(zoneItem,level);
	}	
	
	return levelItem;
}

/** Used to find out which level a item is at */
signed int DlgMapSpeedwalk::getLevelOfItem(QListViewItem *item)
{
	signed int count=-1;
	
	while (item!=NULL)
	{
		count++;	
		item = item->parent();
	}
	
	return count;
}

/** Delete all the elements based on the zone */
bool DlgMapSpeedwalk::deleteZone(QListViewItem *item)
{
	bool found;
	CMapRoom *room = getRoom(item);
	if (room)
	{
		CMapRoom *room2 =mapData->speedwalkList.last();
		while(room2!=0)
		{
			if (room2->getZone()==room->getZone())
			{
				mapData->speedwalkList.remove(room2);
				found = true;
				room2 = mapData->speedwalkList.last();								
			}
			else
			{
				room2 = mapData->speedwalkList.prev();
			}
		}												
	}
	
	return found;
}

/** Delete all the elements based on the level and zone */
bool DlgMapSpeedwalk::deleteLevel(QListViewItem *item)
{
	bool found;
	CMapRoom *room = getRoom(item);
	if (room)
	{
		CMapRoom *room2 =mapData->speedwalkList.last();
		while(room2!=0)
		{
			if (room2->getZone()==room->getZone() && room2->getLevel()==room->getLevel())
			{
				mapData->speedwalkList.remove(room2);
				found = true;
				room2 = mapData->speedwalkList.last();								
			}
			else
			{
				room2 = mapData->speedwalkList.prev();
			}
		}												
	}
	
	return found;
}

/** Used to delete a room from the speedwalk list */
bool DlgMapSpeedwalk::deleteRoom(QListViewItem *roomItem)
{
	CMapRoom *room = getRoom(roomItem);
	if (room)
	{
		mapData->speedwalkList.remove(room);	
		return true;
	}

	return false;
}

/** This slot is called when the delete button is pressed */
void DlgMapSpeedwalk::slotDelete(void)
{
	bool found = false;
	QListViewItem *currentItem = lstSpeedwalk->currentItem();
	if (currentItem == 0) return;
	
	int currentLevel = getLevelOfItem(currentItem);

	switch (mapData->speedwalkCatogrize)
	{
		case 0 : if (deleteRoom(currentItem)) found = true;
		         break;
		
		case 1 : if (currentLevel==0)
		         {		         	
			        if (deleteZone(currentItem->firstChild())) found = true;		
		         }
		
		         if (currentLevel==1)
		         {
	         		if (deleteRoom(currentItem)) found = true;		
		         }
		         break;
		
		case 2 : if (currentLevel==0)
				 {				 	
			        if (deleteZone(currentItem->firstChild()->firstChild())) found = true;						
				 }
				
				 if (currentLevel==1)
				 {
				 	if (deleteLevel(currentItem->firstChild())) found = true;
				 }
				
				 if (currentLevel==2)
		         {
	         		if (deleteRoom(currentItem)) found = true;
		         }
		         break;
	}
	
	if (found)	updateSpeedwalkList(NULL);	
}

/** This slot is called when the delete button is pressed */
void DlgMapSpeedwalk::slotSpeedwalk(void)
{
	QListViewItem *currentItem = lstSpeedwalk->currentItem();
	if (currentItem == 0) return;
	
	CMapRoom *room = getRoom(lstSpeedwalk->currentItem() );	
	int currentLevel = getLevelOfItem(currentItem);

	if (currentLevel==mapData->speedwalkCatogrize) mapWidget->walkPlayerTo(room);
}

/** This is used to dislpay the room properties dialog */
void DlgMapSpeedwalk::slotProperties(void)
{
	QListViewItem *currentItem = lstSpeedwalk->currentItem();
	if (currentItem == 0) return;
	
	CMapRoom *room = getRoom(lstSpeedwalk->currentItem() );	
	int currentLevel = getLevelOfItem(currentItem);

	if (currentLevel==mapData->speedwalkCatogrize)
	{
		mapWidget->roomProperties(room);
	}
}

/** slot for double click events on the list view */
void DlgMapSpeedwalk::slotDoubleClicked(QListViewItem* item)
{
  CMapRoom* room = getRoom(item);

  // switch level and zone
  mapWidget->showLevel(-1, -1, room->getLevel(), room->getZone());

  //change position
  mapWidget->getMapView()->center(room->getHiX(), room->getHiY());
}
