/***************************************************************************
                          dlgmapoptionspreferences.cpp
                      -------------------
    description          : Preferences Dialog Class
    begin                : Fri Apr 28 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>

#include "dlgmapoptionspreferences.h"

DlgMapOptionsPreferences::DlgMapOptionsPreferences(QWidget *parent, const char *name)
 : QTabDialog(parent,name, true)
{
  setCaption(i18n("Mapper Preferences"));

	directionsTab = new DlgMapOptionsDirections(this,"Directions");
	coloursTab = new DlgMapOptionsColours(this,"Color");
	miscTab = new DlgMapOptionsMisc(this,"Misc");	
	speedwalkTab = new DlgMapOptionsSpeedwalk(this,"Misc");	

	setOkButton(i18n("OK"));
	setDefaultButton(i18n("Default"));
	setCancelButton(i18n("Cancel"));

	addTab(directionsTab,i18n("&Directions"));
	addTab(coloursTab,i18n("&Colors"));
	addTab(speedwalkTab,i18n("&Speedwalk"));
	addTab(miscTab,i18n("&Misc"));	

	connect(this, SIGNAL(applyButtonPressed()), SLOT(slotOKPressed()));
	connect(this, SIGNAL(defaultButtonPressed()), SLOT(slotDefaultPressed()));

	this->setFixedSize(430,420);

}

DlgMapOptionsPreferences::~DlgMapOptionsPreferences()
{
}

void DlgMapOptionsPreferences::slotOKPressed()
{
}

void DlgMapOptionsPreferences::slotDefaultPressed()
{
	directionsTab->setNorth("north");
	directionsTab->setNorthEast("northeast");
	directionsTab->setEast("east");
	directionsTab->setSouthEast("southeast");
	directionsTab->setSouth("south");
	directionsTab->setSouthWest("southwest");
	directionsTab->setWest("west");
	directionsTab->setNorthWest("northwest");
	directionsTab->setUp("up");
	directionsTab->setDown("down");

	coloursTab->setBackgroundColour(QColor(201,167,55));
	coloursTab->setGridColour(QColor(213,178,88));
	coloursTab->setDefaultRoomColour(QColor(192,192,192));
	coloursTab->setDefaultPathColour(black);
	coloursTab->setLowerRoomColour(darkGray);
	coloursTab->setLowerPathColour(darkGray);
	coloursTab->setHigherRoomColour(white);
	coloursTab->setHigherPathColour(white);
	coloursTab->setDefaultTextColour(black);
	coloursTab->setSelectedColour(blue);		
	coloursTab->setSpecialColour(yellow);			
	coloursTab->setLoginColour(blue);	
	coloursTab->setEditColour(red);
	coloursTab->setCurrentColour(red);
	
	miscTab->setDoValidMoveChecking(false);
	miscTab->setFailedMoveMsg1("");
	miscTab->setFailedMoveMsg2("");
	miscTab->setFailedMoveMsg3("");
	miscTab->setDefaultTwoWay(true);

	speedwalkTab->setSpeedWalkLimit(1000);
	speedwalkTab->setDoLimitSpeedWalk(true);
	speedwalkTab->setSpeedwalkDelay(20);
}



// Directions

void DlgMapOptionsPreferences::setNorth(QString direction)
{ directionsTab->setNorth(direction); }

void DlgMapOptionsPreferences::setNorthEast(QString direction)
{ directionsTab->setNorthEast(direction); }

void DlgMapOptionsPreferences::setEast(QString direction)
{ directionsTab->setEast(direction); }

void DlgMapOptionsPreferences::setSouthEast(QString direction)
{ directionsTab->setSouthEast(direction); }

void DlgMapOptionsPreferences::setSouth(QString direction)
{ directionsTab->setSouth(direction); }

void DlgMapOptionsPreferences::setSouthWest(QString direction)
{ directionsTab->setSouthWest(direction); }

void DlgMapOptionsPreferences::setWest(QString direction)
{ directionsTab->setWest(direction); }

void DlgMapOptionsPreferences::setNorthWest(QString direction)
{ directionsTab->setNorthWest(direction); }

void DlgMapOptionsPreferences::setUp(QString direction)
{ directionsTab->setUp(direction); }

void DlgMapOptionsPreferences::setDown(QString direction)
{ directionsTab->setDown(direction); }

QString DlgMapOptionsPreferences::getNorth(void)
{ return directionsTab->getNorth(); }

QString DlgMapOptionsPreferences::getNorthEast(void)
{ return directionsTab->getNorthEast(); }

QString DlgMapOptionsPreferences::getEast(void)
{ return directionsTab->getEast(); }

QString DlgMapOptionsPreferences::getSouthEast(void)
{ return directionsTab->getSouthEast(); }

QString DlgMapOptionsPreferences::getSouth(void)
{ return directionsTab->getSouth(); }

QString DlgMapOptionsPreferences::getSouthWest(void)
{ return directionsTab->getSouthWest(); }

QString DlgMapOptionsPreferences::getWest(void)
{ return directionsTab->getWest(); }

QString DlgMapOptionsPreferences::getNorthWest(void)
{ return directionsTab->getNorthWest(); }

QString DlgMapOptionsPreferences::getUp(void)
{ return directionsTab->getUp(); }

QString DlgMapOptionsPreferences::getDown(void)
{ return directionsTab->getDown(); }



// Colors

void DlgMapOptionsPreferences::setBackgroundColour(QColor col)
{	coloursTab->setBackgroundColour(col); }

void DlgMapOptionsPreferences::setGridColour(QColor col)
{ coloursTab->setGridColour(col); }

void DlgMapOptionsPreferences::setDefaultTextColour(QColor col)
{ coloursTab->setDefaultTextColour(col); }

void DlgMapOptionsPreferences::setSelectedColour(QColor col)
{ coloursTab->setSelectedColour(col); }

void DlgMapOptionsPreferences::setSpecialColour(QColor col)
{ coloursTab->setSpecialColour(col); }

void DlgMapOptionsPreferences::setLoginColour(QColor col)
{ coloursTab->setLoginColour(col); }

void DlgMapOptionsPreferences::setEditColour(QColor col)
{ coloursTab->setEditColour(col); }

void DlgMapOptionsPreferences::setCurrentColour(QColor col)
{ coloursTab->setCurrentColour(col); }

void DlgMapOptionsPreferences::setDefaultRoomColour(QColor col)
{ coloursTab->setDefaultRoomColour(col); }

void DlgMapOptionsPreferences::setDefaultPathColour(QColor col)
{ coloursTab->setDefaultPathColour(col); }

void DlgMapOptionsPreferences::setLowerRoomColour(QColor col)
{ coloursTab->setLowerRoomColour(col); }

void DlgMapOptionsPreferences::setLowerPathColour(QColor col)
{ coloursTab->setLowerPathColour(col); }

void DlgMapOptionsPreferences::setHigherRoomColour(QColor col)
{ coloursTab->setHigherRoomColour(col); }

void DlgMapOptionsPreferences::setHigherPathColour(QColor col)
{ coloursTab->setHigherPathColour(col); }

QColor DlgMapOptionsPreferences::getBackgroundColour(void)
{ return coloursTab->getBackgroundColour(); }

QColor DlgMapOptionsPreferences::getGridColour(void)
{ return coloursTab->getGridColour(); }

QColor DlgMapOptionsPreferences::getDefaultRoomColour(void)
{ return coloursTab->getDefaultRoomColour(); }

QColor DlgMapOptionsPreferences::getDefaultPathColour(void)
{ return coloursTab->getDefaultPathColour(); }

QColor DlgMapOptionsPreferences::getDefaultTextColour(void)
{ return coloursTab->getDefaultTextColour(); }

QColor DlgMapOptionsPreferences::getSelectedColour(void)
{ return coloursTab->getSelectedColour(); }

QColor DlgMapOptionsPreferences::getSpecialColour(void)
{ return coloursTab->getSpecialColour(); }

QColor DlgMapOptionsPreferences::getEditColour(void)
{ return coloursTab->getEditColour(); }

QColor DlgMapOptionsPreferences::getCurrentColour(void)
{ return coloursTab->getCurrentColour(); }

QColor DlgMapOptionsPreferences::getLoginColour(void)
{ return coloursTab->getLoginColour(); }

QColor DlgMapOptionsPreferences::getLowerRoomColour(void)
{ return coloursTab->getLowerRoomColour(); }

QColor DlgMapOptionsPreferences::getLowerPathColour(void)
{ return coloursTab->getLowerPathColour(); }

QColor DlgMapOptionsPreferences::getHigherRoomColour(void)
{ return coloursTab->getHigherRoomColour(); }

QColor DlgMapOptionsPreferences::getHigherPathColour(void)
{ return coloursTab->getHigherPathColour(); }



// Misc

bool DlgMapOptionsPreferences::getDoValidMoveChecking(void)
{ return miscTab->getDoValidMoveChecking(); }

void DlgMapOptionsPreferences::setDoValidMoveChecking(bool b)
{ miscTab->setDoValidMoveChecking(b); }

QString DlgMapOptionsPreferences::getFailedMoveMsg1(void)
{ return miscTab->getFailedMoveMsg1(); }

void DlgMapOptionsPreferences::setFailedMoveMsg1(QString s)
{ miscTab->setFailedMoveMsg1(s); }

QString DlgMapOptionsPreferences::getFailedMoveMsg2(void)
{ return miscTab->getFailedMoveMsg2(); }

void DlgMapOptionsPreferences::setFailedMoveMsg2(QString s)
{ miscTab->setFailedMoveMsg2(s); }

QString DlgMapOptionsPreferences::getFailedMoveMsg3(void)
{ return miscTab->getFailedMoveMsg3(); }

void DlgMapOptionsPreferences::setFailedMoveMsg3(QString s)
{ miscTab->setFailedMoveMsg3(s); }


void DlgMapOptionsPreferences::setDefaultTwoWay(bool set)
{ miscTab->setDefaultTwoWay(set); }
	
bool DlgMapOptionsPreferences::getDefaultTwoWay(void)
{ return miscTab->getDefaultTwoWay(); }


// Speedwalk tab
bool DlgMapOptionsPreferences::getDoLimitSpeedWalk(void)
{ return speedwalkTab->getDoLimitSpeedWalk(); }

void DlgMapOptionsPreferences::setDoLimitSpeedWalk(bool set)
{ speedwalkTab->setDoLimitSpeedWalk(set); }

int DlgMapOptionsPreferences::getSpeedWalkLimit(void)
{ return speedwalkTab->getSpeedWalkLimit(); }

void DlgMapOptionsPreferences::setSpeedWalkLimit(int limit)
{ speedwalkTab->setSpeedWalkLimit(limit); }

int DlgMapOptionsPreferences::getSpeedwalkDelay(void)
{ return speedwalkTab->getSpeedwalkDelay(); }

void DlgMapOptionsPreferences::setSpeedwalkDelay(int delay)
{ speedwalkTab->setSpeedwalkDelay(delay); }
