/*
**  ArtCan - Tobi
*/

#define CANTIME 	((time_t)(60*60*4)) /* alle 4 Stunden eine can */
#define MAXCANSIZE	(100*1024*1024)	    /* max 100MB pro can */
#define READ 0
#define WRITE 1

#define MAXOPENREADCANS 24
#define MAXOPENWRITECANS 8

typedef struct _ARTCAN {
    char		Version;	/* 1 */
    time_t		Delete;	
    char		*Name;		/* .../shelf_xxx/199704232201 */
    int			Number;
    int			fd[2];		/* filedescriptor */
    long		Bytepos[2];
    char		AccessFlag[2];
    char		dirty;
} ARTCAN;

#ifndef MAX
#define MAX(x,y) ( (x)>(y) ? (x) : (y) )
#endif

extern ARTCAN	*openCans[2][MAX(MAXOPENREADCANS,MAXOPENWRITECANS)];
extern int	openCansPos[2];
extern int	maxOpenCans[2];

extern tree	*canTree[2];

#ifdef __STDC__
#define __P(x) x
#else
#define	__P(x) ()
#endif

void 	CANsetup		();
void	CANrestart		();
void	CANnop			();

void CANfree			__P( (ARTCAN *) );

void	CANsync			();
void	CANclose		();
void	CANsyncCan		();
void	CANcloseCan		__P( (int, ARTCAN *) );

int	compareCanByName	__P( (ARTCAN *, ARTCAN *) );
int 	compareWriteCan		__P( (ARTCAN *, ARTCAN *) );
int	compareReadCan		__P( (ARTCAN *, ARTCAN *) );

int	CANrecover		__P( (int) );
int	CANcheck		__P( (int) );
time_t	CANdelete		__P( (char *) );
long 	CANartsize		__P( (ARTCAN *) );

int	CANdescriptorCycle	__P( (int, ARTCAN *) );
ARTCAN *CANcreate		__P( (ARTCAN *, time_t) );

ARTCAN *CANopenByName		__P( (char *) );
ARTCAN *CANopenForWrite		__P( (time_t, long) );
ARTCAN *CANopenForRead		__P( (char *) );
ARTCAN *CANopenByNameForRead    __P( (char *) );


#undef __P
