//
// C++ Interface: outputbuffer
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef OUTPUTBUFFER_H
#define OUTPUTBUFFER_H

#include <list>
#include <string>

#include "my_sstream.h"

/**
contains the output buffer.  Each line is stored in a different string

@author Lorenzo Bettini
*/
class OutputBuffer : public std::list<std::string>
{
  private:
    typedef std::list<std::string> Base;

    ostringstream buffer;

  public:
    OutputBuffer();
    using Base::const_iterator;
    using Base::begin;
    using Base::end;

    ~OutputBuffer();

    void output(const std::string &s) { buffer << s; }
    void output(int i) { buffer << i; }
    void output_ln(const std::string &s);

    void reset();
    void flush();
};

#endif
